/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers;

import com.jprofiler.agent.triggers.ThresholdTrigger;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import com.jprofiler.agent.util.ag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ThresholdManager {
    private static List<ThresholdTrigger> cpuTriggers = new ArrayList<ThresholdTrigger>();
    private static List<ThresholdTrigger> heapTriggers = new ArrayList<ThresholdTrigger>();
    private static boolean cpuNotAvailableWarning = false;
    private static boolean heapNotAvailableWarning = false;

    public static synchronized void clearTriggers() {
        cpuTriggers.clear();
        heapTriggers.clear();
    }

    public static synchronized ThresholdTrigger addTrigger(ThresholdTrigger thresholdTrigger, boolean bl2) {
        if (bl2) {
            cpuTriggers.add(thresholdTrigger);
        } else {
            heapTriggers.add(thresholdTrigger);
        }
        return thresholdTrigger;
    }

    public static ThresholdTrigger createTrigger(XMLElement xMLElement) throws IOException {
        String string = xMLElement.getName();
        ThresholdTrigger thresholdTrigger = string.equals("cpuThreshold") ? ThresholdManager.addTrigger(new ThresholdTrigger(xMLElement), true) : (string.equals("heapThreshold") ? ThresholdManager.addTrigger(new ThresholdTrigger(xMLElement), false) : null);
        return thresholdTrigger;
    }

    public static synchronized void check(int n2, int n3) {
        long l2 = System.currentTimeMillis();
        if (n3 == -1) {
            if (!cpuNotAvailableWarning && cpuTriggers.size() > 0) {
                cpuNotAvailableWarning = true;
                System.err.println("JProfiler> *******************************************************************");
                System.err.println("JProfiler> WARNING: CPU threshold triggers are not available.");
                if (ag.c >= 9) {
                    System.err.println("JProfiler> JDK module java.management might not be present.");
                }
                System.err.println("JProfiler> *******************************************************************");
            }
        } else {
            for (ThresholdTrigger thresholdTrigger : cpuTriggers) {
                thresholdTrigger.check(n3, l2);
            }
        }
        if (n2 == -1) {
            if (!heapNotAvailableWarning && heapTriggers.size() > 0) {
                heapNotAvailableWarning = true;
                System.err.println("JProfiler> *******************************************************************");
                System.err.println("JProfiler> WARNING: Heap threshold triggers are not available.");
                System.err.println("JProfiler> *******************************************************************");
            }
        } else {
            for (ThresholdTrigger thresholdTrigger : heapTriggers) {
                thresholdTrigger.check(n2, l2);
            }
        }
    }
}

