/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.encoding.core;

import io.matthewnelson.encoding.core.Decoder;
import io.matthewnelson.encoding.core.Encoder;
import io.matthewnelson.encoding.core.EncodingException;
import io.matthewnelson.encoding.core.EncodingSizeException;
import io.matthewnelson.encoding.core.MalformedEncodingException;
import io.matthewnelson.encoding.core.util.DecoderInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 \u000f*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003\u000f\u0010\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0086\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH$J\u0006\u0010\u000e\u001a\u00020\r\u00a8\u0006\u0012"}, d2={"Lio/matthewnelson/encoding/core/EncoderDecoder;", "C", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "Lio/matthewnelson/encoding/core/Encoder;", "config", "(Lio/matthewnelson/encoding/core/EncoderDecoder$Config;)V", "equals", "", "other", "", "hashCode", "", "name", "", "toString", "Companion", "Config", "Feed", "io.matthewnelson.encoding_core_jvm"})
public abstract class EncoderDecoder<C extends Config>
extends Encoder<C> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public EncoderDecoder(@NotNull C config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        super((Config)config, null);
    }

    @NotNull
    protected abstract String name();

    public final boolean equals(@Nullable Object other) {
        if (!(other instanceof EncoderDecoder)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((EncoderDecoder)other).name(), (Object)this.name())) {
            return false;
        }
        return Intrinsics.areEqual(((EncoderDecoder)other).getConfig(), this.getConfig());
    }

    public final int hashCode() {
        int result = 17;
        result = result * 31 + this.name().hashCode();
        result = result * 31 + ((Config)this.getConfig()).hashCode();
        return result;
    }

    @NotNull
    public final String toString() {
        return "EncoderDecoder[" + this.name() + "]@" + this.hashCode();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/matthewnelson/encoding/core/EncoderDecoder$Companion;", "", "()V", "DEFAULT_BUFFER_SIZE", "", "io.matthewnelson.encoding_core_jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 ,2\u00020\u0001:\u0002,-BC\b\u0014\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rB#\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH$J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH$J\u0011\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0086\bJ\u0016\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aJ\u0016\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aH\u0007J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aH$J\u0013\u0010%\u001a\u00020\u00032\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u0086\u0002J\u0006\u0010'\u001a\u00020\nJ\u0006\u0010(\u001a\u00020\u0011J\u0012\u0010)\u001a\f\u0012\b\u0012\u00060+R\u00020\u00000*H$R!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\f\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018\u00a8\u0006."}, d2={"Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "", "isLenient", "", "lineBreakInterval", "", "lineBreakResetOnFlush", "paddingChar", "", "maxDecodeEmit", "", "maxEncodeEmit", "backFillBuffers", "(Ljava/lang/Boolean;BZLjava/lang/Character;IIZ)V", "(Ljava/lang/Boolean;BLjava/lang/Character;)V", "_toStringAddSettings", "", "", "get_toStringAddSettings", "()Ljava/util/List;", "_toStringAddSettings$delegate", "Lkotlin/Lazy;", "Ljava/lang/Boolean;", "maxEncodeEmitWithLineBreak", "Ljava/lang/Character;", "decodeOutMaxSize", "", "encodedSize", "decodeOutMaxSizeOrFail", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "decodeOutMaxSizeOrFailProtected", "decodeOutMaxSizeProtected", "encodeOutMaxSize", "unEncodedSize", "encodeOutSize", "encodeOutSizeProtected", "equals", "other", "hashCode", "toString", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "Companion", "Setting", "io.matthewnelson.encoding_core_jvm"})
    @SourceDebugExtension(value={"SMAP\nEncoderDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncoderDecoder.kt\nio/matthewnelson/encoding/core/EncoderDecoder$Config\n+ 2 EncoderDecoder.kt\nio/matthewnelson/encoding/core/EncoderDecoderKt\n+ 3 -Util.kt\nio/matthewnelson/encoding/core/internal/_UtilKt\n*L\n1#1,873:1\n859#2,10:874\n859#2,10:884\n853#2:894\n871#2:895\n871#2:896\n871#2:900\n853#2:901\n31#3,3:897\n*S KotlinDebug\n*F\n+ 1 EncoderDecoder.kt\nio/matthewnelson/encoding/core/EncoderDecoder$Config\n*L\n204#1:874,10\n205#1:884,10\n207#1:894\n263#1:895\n369#1:896\n432#1:900\n687#1:901\n406#1:897,3\n*E\n"})
    public static abstract class Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @Nullable
        public final Boolean isLenient;
        @JvmField
        public final byte lineBreakInterval;
        @JvmField
        public final boolean lineBreakResetOnFlush;
        @JvmField
        @Nullable
        public final Character paddingChar;
        @JvmField
        public final int maxDecodeEmit;
        @JvmField
        public final int maxEncodeEmit;
        @JvmField
        public final int maxEncodeEmitWithLineBreak;
        @JvmField
        public final boolean backFillBuffers;
        @NotNull
        private final Lazy _toStringAddSettings$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ Config this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<String> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.this$0.toStringAddSettings();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Setting setting = (Setting)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toString());
                }
                return (List)destination$iv$iv;
            }
        }));

        /*
         * WARNING - void declaration
         */
        protected Config(@Nullable Boolean isLenient, byte lineBreakInterval, boolean lineBreakResetOnFlush, @Nullable Character paddingChar, int maxDecodeEmit, int maxEncodeEmit, boolean backFillBuffers) {
            void isLenient$iv;
            int size$iv = maxDecodeEmit;
            boolean $i$f$checkMaxEmitSize = false;
            if (size$iv <= 0) {
                boolean bl = false;
                String n$iv = "maxDecodeEmit";
                throw new IllegalArgumentException(n$iv + " must be greater than 0");
            }
            if (size$iv >= 256) {
                boolean bl = false;
                String n$iv = "maxDecodeEmit";
                throw new IllegalArgumentException(n$iv + " must be less than 256");
            }
            size$iv = maxEncodeEmit;
            $i$f$checkMaxEmitSize = false;
            if (size$iv <= 0) {
                boolean bl = false;
                String n$iv = "maxEncodeEmit";
                throw new IllegalArgumentException(n$iv + " must be greater than 0");
            }
            if (size$iv >= 256) {
                boolean bl = false;
                String n$iv = "maxEncodeEmit";
                throw new IllegalArgumentException(n$iv + " must be less than 256");
            }
            this.isLenient = isLenient;
            Boolean size$iv2 = isLenient;
            byte interval$iv = lineBreakInterval;
            boolean $i$f$lineBreakIntervalOrZero = false;
            this.lineBreakInterval = !Intrinsics.areEqual((Object)isLenient$iv, (Object)false) && interval$iv > 0 ? interval$iv : (byte)0;
            this.lineBreakResetOnFlush = lineBreakResetOnFlush;
            this.paddingChar = paddingChar;
            this.maxDecodeEmit = maxDecodeEmit;
            this.maxEncodeEmit = maxEncodeEmit;
            this.maxEncodeEmitWithLineBreak = Companion.calculateMaxEncodeEmit(maxEncodeEmit, this.lineBreakInterval);
            this.backFillBuffers = backFillBuffers;
        }

        public final long encodeOutMaxSize(long unEncodedSize) throws EncodingSizeException {
            return this.encodeOutMaxSize(unEncodedSize, this.lineBreakInterval);
        }

        public final long encodeOutMaxSize(long unEncodedSize, byte lineBreakInterval) throws EncodingSizeException {
            double lineBreakCount;
            if (unEncodedSize < 0L) {
                throw new EncodingSizeException("unEncodedSize cannot be negative");
            }
            if (unEncodedSize == 0L) {
                return 0L;
            }
            long outSize = this.encodeOutSizeProtected(unEncodedSize);
            if (outSize < 0L) {
                Number outSize$iv = outSize;
                boolean $i$f$negativeEncodingSizeException = false;
                throw new EncodingSizeException("Calculated output of Size[" + outSize$iv + "] was negative");
            }
            if (lineBreakInterval > 0 && (lineBreakCount = (double)(outSize / (long)lineBreakInterval) - 1.0) > 0.0) {
                if (lineBreakCount % 1.0 > 0.0) {
                    double d = lineBreakCount;
                    lineBreakCount = d + 1.0;
                }
                if ((double)outSize > (double)Long.MAX_VALUE - lineBreakCount) {
                    throw Companion.outSizeExceedsMaxEncodingSizeException(unEncodedSize, Long.MAX_VALUE);
                }
                outSize += (long)lineBreakCount;
            }
            return outSize;
        }

        public final int encodeOutMaxSize(int unEncodedSize) throws EncodingSizeException {
            boolean $i$f$encodeOutMaxSize = false;
            return this.encodeOutMaxSize(unEncodedSize, this.lineBreakInterval);
        }

        public final int encodeOutMaxSize(int unEncodedSize, byte lineBreakInterval) throws EncodingSizeException {
            long outSize = this.encodeOutMaxSize((long)unEncodedSize, lineBreakInterval);
            if (outSize <= Integer.MAX_VALUE) {
                return (int)outSize;
            }
            throw Companion.outSizeExceedsMaxEncodingSizeException(unEncodedSize, Integer.MAX_VALUE);
        }

        public final long decodeOutMaxSize(long encodedSize) throws EncodingSizeException {
            if (encodedSize < 0L) {
                throw new EncodingSizeException("encodedSize cannot be negative");
            }
            if (encodedSize == 0L) {
                return 0L;
            }
            long outSize = this.decodeOutMaxSizeProtected(encodedSize);
            if (outSize < 0L) {
                Number outSize$iv = outSize;
                boolean $i$f$negativeEncodingSizeException = false;
                throw new EncodingSizeException("Calculated output of Size[" + outSize$iv + "] was negative");
            }
            return outSize;
        }

        public final int decodeOutMaxSizeOrFail(@NotNull DecoderInput input) throws EncodingException {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int lastRelevantChar = input.getSize$io_matthewnelson_encoding_core_jvm();
            while (lastRelevantChar > 0) {
                char c = input.get(lastRelevantChar - 1);
                if (this.isLenient != null) {
                    boolean bl;
                    char $this$isSpaceOrNewLine$iv = c;
                    boolean $i$f$isSpaceOrNewLine = false;
                    switch ($this$isSpaceOrNewLine$iv) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            bl = true;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    if (bl) {
                        if (this.isLenient.booleanValue()) {
                            --lastRelevantChar;
                            continue;
                        }
                        throw new MalformedEncodingException("Spaces and new lines are forbidden when isLenient[false]");
                    }
                }
                Character c2 = this.paddingChar;
                if (c2 == null || c != c2.charValue()) break;
                --lastRelevantChar;
            }
            if (lastRelevantChar == 0) {
                return 0;
            }
            int outSize = this.decodeOutMaxSizeOrFailProtected(lastRelevantChar, input);
            if (outSize < 0) {
                Number outSize$iv = outSize;
                boolean $i$f$negativeEncodingSizeException = false;
                throw new EncodingSizeException("Calculated output of Size[" + outSize$iv + "] was negative");
            }
            return outSize;
        }

        protected abstract long encodeOutSizeProtected(long var1) throws EncodingSizeException;

        protected abstract long decodeOutMaxSizeProtected(long var1) throws EncodingException;

        protected abstract int decodeOutMaxSizeOrFailProtected(int var1, @NotNull DecoderInput var2) throws EncodingException;

        @NotNull
        protected abstract Set<Setting> toStringAddSettings();

        private final List<String> get_toStringAddSettings() {
            Lazy lazy = this._toStringAddSettings$delegate;
            return (List)lazy.getValue();
        }

        public final boolean equals(@Nullable Object other) {
            if (!(other instanceof Config)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((Config)other).isLenient, (Object)this.isLenient)) {
                return false;
            }
            if (((Config)other).lineBreakInterval != this.lineBreakInterval) {
                return false;
            }
            if (((Config)other).lineBreakResetOnFlush != this.lineBreakResetOnFlush) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((Config)other).paddingChar, (Object)this.paddingChar)) {
                return false;
            }
            if (((Config)other).maxDecodeEmit != this.maxDecodeEmit) {
                return false;
            }
            if (((Config)other).maxEncodeEmit != this.maxEncodeEmit) {
                return false;
            }
            if (((Config)other).backFillBuffers != this.backFillBuffers) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            return Intrinsics.areEqual(((Config)other).get_toStringAddSettings(), this.get_toStringAddSettings());
        }

        public final int hashCode() {
            int result = 17;
            Boolean bl = this.isLenient;
            result = result * 31 + (bl != null ? ((Object)bl).hashCode() : 0);
            result = result * 31 + Byte.hashCode(this.lineBreakInterval);
            result = result * 31 + Boolean.hashCode(this.lineBreakResetOnFlush);
            Character c = this.paddingChar;
            result = result * 31 + (c != null ? ((Object)c).hashCode() : 0);
            result = result * 31 + Integer.hashCode(this.maxDecodeEmit);
            result = result * 31 + Integer.hashCode(this.maxEncodeEmit);
            result = result * 31 + Boolean.hashCode(this.backFillBuffers);
            result = result * 31 + Reflection.getOrCreateKotlinClass(this.getClass()).hashCode();
            result = result * 31 + ((Object)this.get_toStringAddSettings()).hashCode();
            return result;
        }

        @NotNull
        public final String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append("EncoderDecoder.Config [").append('\n');
            $this$toString_u24lambda_u240.append("    isLenient: ");
            $this$toString_u24lambda_u240.append(this.isLenient).append('\n');
            $this$toString_u24lambda_u240.append("    lineBreakInterval: ");
            StringBuilder stringBuilder2 = $this$toString_u24lambda_u240.append(this.lineBreakInterval);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            stringBuilder2.append('\n');
            $this$toString_u24lambda_u240.append("    lineBreakResetOnFlush: ");
            $this$toString_u24lambda_u240.append(this.lineBreakResetOnFlush).append('\n');
            $this$toString_u24lambda_u240.append("    paddingChar: ");
            $this$toString_u24lambda_u240.append(this.paddingChar).append('\n');
            $this$toString_u24lambda_u240.append("    maxDecodeEmit: ");
            StringBuilder stringBuilder3 = $this$toString_u24lambda_u240.append(this.maxDecodeEmit);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            stringBuilder3.append('\n');
            $this$toString_u24lambda_u240.append("    maxEncodeEmit: ");
            StringBuilder stringBuilder4 = $this$toString_u24lambda_u240.append(this.maxEncodeEmit);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            stringBuilder4.append('\n');
            $this$toString_u24lambda_u240.append("    backFillBuffers: ");
            $this$toString_u24lambda_u240.append(this.backFillBuffers);
            for (String setting : this.get_toStringAddSettings()) {
                $this$toString_u24lambda_u240.append('\n');
                $this$toString_u24lambda_u240.append("    ");
                $this$toString_u24lambda_u240.append(setting);
            }
            $this$toString_u24lambda_u240.append('\n');
            $this$toString_u24lambda_u240.append(']');
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026']')\n        }.toString()");
            return string;
        }

        @Deprecated(message="Function name changed.", replaceWith=@ReplaceWith(expression="encodeOutMaxSize(unEncodedSize)", imports={}), level=DeprecationLevel.WARNING)
        public final long encodeOutSize(long unEncodedSize) {
            return this.encodeOutMaxSize(unEncodedSize, this.lineBreakInterval);
        }

        @Deprecated(message="Function name changed.", replaceWith=@ReplaceWith(expression="encodeOutMaxSize(unEncodedSize, lineBreakInterval)", imports={}), level=DeprecationLevel.WARNING)
        public final long encodeOutSize(long unEncodedSize, byte lineBreakInterval) {
            return this.encodeOutMaxSize(unEncodedSize, lineBreakInterval);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="Parameters, lineBreakResetOnFlush, maxDecodeEmit, maxEncodeEmit, and backFillBuffers were added. Use the new constructor.", replaceWith=@ReplaceWith(expression="EncoderDecoder.Config(isLenient, lineBreakInterval, lineBreakResetOnFlush = false, paddingChar, maxDecodeEmit = 0 /* TODO */, maxEncodeEmit = 0 /* TODO */, backFillBuffers = true)", imports={}), level=DeprecationLevel.WARNING)
        public Config(@Nullable Boolean isLenient, byte lineBreakInterval, @Nullable Character paddingChar) {
            void isLenient$iv;
            this.isLenient = isLenient;
            Boolean bl = isLenient;
            byte interval$iv = lineBreakInterval;
            boolean $i$f$lineBreakIntervalOrZero = false;
            this.lineBreakInterval = !Intrinsics.areEqual((Object)isLenient$iv, (Object)false) && interval$iv > 0 ? interval$iv : (byte)0;
            this.lineBreakResetOnFlush = false;
            this.paddingChar = paddingChar;
            this.maxDecodeEmit = -1;
            this.maxEncodeEmit = -1;
            this.maxEncodeEmitWithLineBreak = -1;
            this.backFillBuffers = true;
        }

        @JvmStatic
        public static final int calculateMaxEncodeEmit(int emitSize, int insertionInterval) {
            return Companion.calculateMaxEncodeEmit(emitSize, insertionInterval);
        }

        @JvmStatic
        @NotNull
        public static final EncodingSizeException outSizeExceedsMaxEncodingSizeException(@NotNull Number inputSize, @NotNull Number maxSize) {
            return Companion.outSizeExceedsMaxEncodingSizeException(inputSize, maxSize);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Companion;", "", "()V", "calculateMaxEncodeEmit", "", "emitSize", "insertionInterval", "outSizeExceedsMaxEncodingSizeException", "Lio/matthewnelson/encoding/core/EncodingSizeException;", "inputSize", "", "maxSize", "io.matthewnelson.encoding_core_jvm"})
        @SourceDebugExtension(value={"SMAP\nEncoderDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncoderDecoder.kt\nio/matthewnelson/encoding/core/EncoderDecoder$Config$Companion\n+ 2 EncoderDecoder.kt\nio/matthewnelson/encoding/core/EncoderDecoderKt\n*L\n1#1,873:1\n859#2,10:874\n*S KotlinDebug\n*F\n+ 1 EncoderDecoder.kt\nio/matthewnelson/encoding/core/EncoderDecoder$Config$Companion\n*L\n467#1:874,10\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            public final int calculateMaxEncodeEmit(int emitSize, int insertionInterval) {
                int size$iv = emitSize;
                boolean $i$f$checkMaxEmitSize = false;
                if (size$iv <= 0) {
                    boolean bl = false;
                    String n$iv = "emitSize";
                    throw new IllegalArgumentException(n$iv + " must be greater than 0");
                }
                if (size$iv >= 256) {
                    boolean bl = false;
                    String n$iv = "emitSize";
                    throw new IllegalArgumentException(n$iv + " must be less than 256");
                }
                if (insertionInterval <= 0) {
                    return emitSize;
                }
                if (insertionInterval >= emitSize) {
                    return emitSize + 1;
                }
                int count = insertionInterval;
                int output = 0;
                int i = 0;
                while (i++ < emitSize) {
                    if (count == insertionInterval) {
                        ++output;
                        count = 0;
                    }
                    ++output;
                    ++count;
                }
                return output;
            }

            @JvmStatic
            @NotNull
            public final EncodingSizeException outSizeExceedsMaxEncodingSizeException(@NotNull Number inputSize, @NotNull Number maxSize) {
                Intrinsics.checkNotNullParameter((Object)inputSize, (String)"inputSize");
                Intrinsics.checkNotNullParameter((Object)maxSize, (String)"maxSize");
                return new EncodingSizeException("Size[" + inputSize + "] of input would exceed the maximum output Size[" + maxSize + "] for this operation.");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "", "name", "", "value", "(Lio/matthewnelson/encoding/core/EncoderDecoder$Config;Ljava/lang/String;Ljava/lang/Object;)V", "equals", "", "other", "hashCode", "", "toString", "io.matthewnelson.encoding_core_jvm"})
        protected final class Setting {
            @JvmField
            @Nullable
            public final Object value;
            @JvmField
            @NotNull
            public final String name;

            public Setting(@Nullable String name, Object value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.value = value;
                this.name = ((Object)StringsKt.trim((CharSequence)name)).toString();
            }

            public boolean equals(@Nullable Object other) {
                return other instanceof Setting && Intrinsics.areEqual((Object)((Setting)other).name, (Object)this.name);
            }

            public int hashCode() {
                return 527 + this.name.hashCode();
            }

            @NotNull
            public String toString() {
                return this.name + ": " + this.value;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH&J\u0006\u0010\u000b\u001a\u00020\nJ\b\u0010\f\u001a\u00020\nH$J\b\u0010\r\u001a\u00020\nH&J\b\u0010\u000e\u001a\u00020\u000fH&R\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/matthewnelson/encoding/core/EncoderDecoder$Feed;", "C", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "", "config", "(Lio/matthewnelson/encoding/core/EncoderDecoder$Config;)V", "getConfig", "()Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "close", "", "doFinal", "doFinalProtected", "flush", "isClosed", "", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "io.matthewnelson.encoding_core_jvm"})
    @SourceDebugExtension(value={"SMAP\nEncoderDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncoderDecoder.kt\nio/matthewnelson/encoding/core/EncoderDecoder$Feed\n+ 2 -Util.kt\nio/matthewnelson/encoding/core/internal/_UtilKt\n*L\n1#1,873:1\n27#2:874\n*S KotlinDebug\n*F\n+ 1 EncoderDecoder.kt\nio/matthewnelson/encoding/core/EncoderDecoder$Feed\n*L\n766#1:874\n*E\n"})
    public static abstract class Feed<C extends Config> {
        @NotNull
        private final C config;

        private Feed(C config) {
            this.config = config;
        }

        @NotNull
        public final C getConfig() {
            return this.config;
        }

        public abstract boolean isClosed();

        public abstract void flush() throws EncodingException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void doFinal() throws EncodingException {
            if (this.isClosed()) {
                Feed $this$closedException$iv = this;
                boolean $i$f$closedException = false;
                throw new EncodingException($this$closedException$iv + " is closed");
            }
            Feed feed = this;
            if (feed instanceof Decoder.Feed) {
                ((Decoder.Feed)this).markAsClosed$io_matthewnelson_encoding_core_jvm();
            } else if (feed instanceof Encoder.Feed) {
                ((Encoder.Feed)this).markAsClosed$io_matthewnelson_encoding_core_jvm();
            }
            try {
                this.doFinalProtected();
            }
            finally {
                this.close();
            }
        }

        public abstract void close();

        protected abstract void doFinalProtected() throws EncodingException;

        public /* synthetic */ Feed(Config config, DefaultConstructorMarker $constructor_marker) {
            this(config);
        }
    }
}

