/*
 * Decompiled with CFR 0.152.
 */
package jinjava.org.jsoup.parser;

import java.io.StringReader;
import java.util.List;
import jinjava.org.jsoup.nodes.Document;
import jinjava.org.jsoup.nodes.Element;
import jinjava.org.jsoup.nodes.Node;
import jinjava.org.jsoup.parser.HtmlTreeBuilder;
import jinjava.org.jsoup.parser.ParseErrorList;
import jinjava.org.jsoup.parser.ParseSettings;
import jinjava.org.jsoup.parser.TreeBuilder;

public class Parser {
    private TreeBuilder treeBuilder;
    private ParseErrorList errors;
    private ParseSettings settings;
    private boolean trackPosition = false;

    public Parser(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        this.settings = treeBuilder.defaultSettings();
        this.errors = ParseErrorList.noTracking();
    }

    public boolean isTrackErrors() {
        return this.errors.getMaxSize() > 0;
    }

    public ParseErrorList getErrors() {
        return this.errors;
    }

    public boolean isTrackPosition() {
        return this.trackPosition;
    }

    public ParseSettings settings() {
        return this.settings;
    }

    public static Document parse(String html, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parse(new StringReader(html), baseUri, new Parser(treeBuilder));
    }

    public static List<Node> parseFragment(String fragmentHtml, Element context, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parseFragment(fragmentHtml, context, baseUri, new Parser(treeBuilder));
    }

    public static Document parseBodyFragment(String bodyHtml, String baseUri) {
        Document doc = Document.createShell(baseUri);
        Element body = doc.body();
        List<Node> nodeList = Parser.parseFragment(bodyHtml, body, baseUri);
        Node[] nodes = nodeList.toArray(new Node[0]);
        for (int i = nodes.length - 1; i > 0; --i) {
            nodes[i].remove();
        }
        for (Node node : nodes) {
            body.appendChild(node);
        }
        return doc;
    }

    public static Parser htmlParser() {
        return new Parser(new HtmlTreeBuilder());
    }
}

