/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.annotation;

import java.io.IOException;
import java.io.OutputStream;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class AnnotationsWriter {
    protected OutputStream output;
    private ConstPool pool;

    public AnnotationsWriter(OutputStream os, ConstPool cp) {
        this.output = os;
        this.pool = cp;
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void numParameters(int num) throws IOException {
        this.output.write(num);
    }

    public void numAnnotations(int num) throws IOException {
        this.write16bit(num);
    }

    public void annotation(int typeIndex, int numMemberValuePairs) throws IOException {
        this.write16bit(typeIndex);
        this.write16bit(numMemberValuePairs);
    }

    public void memberValuePair(int memberNameIndex) throws IOException {
        this.write16bit(memberNameIndex);
    }

    public void constValueIndex(int tag, int index) throws IOException {
        this.output.write(tag);
        this.write16bit(index);
    }

    public void enumConstValue(int typeNameIndex, int constNameIndex) throws IOException {
        this.output.write(101);
        this.write16bit(typeNameIndex);
        this.write16bit(constNameIndex);
    }

    public void classInfoIndex(int index) throws IOException {
        this.output.write(99);
        this.write16bit(index);
    }

    public void annotationValue() throws IOException {
        this.output.write(64);
    }

    public void arrayValue(int numValues) throws IOException {
        this.output.write(91);
        this.write16bit(numValues);
    }

    protected void write16bit(int value) throws IOException {
        byte[] buf = new byte[2];
        ByteArray.write16bit(value, buf, 0);
        this.output.write(buf);
    }
}

