/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.invocation.InvocationContext;
import java.util.Objects;

public class ToolErrorContext {
    private final ToolExecutionRequest toolExecutionRequest;
    private final InvocationContext invocationContext;

    public ToolErrorContext(Builder builder) {
        this.toolExecutionRequest = ValidationUtils.ensureNotNull(builder.toolExecutionRequest, "toolExecutionRequest");
        this.invocationContext = ValidationUtils.ensureNotNull(builder.invocationContext, "invocationContext");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ToolErrorContext that = (ToolErrorContext)object;
        return Objects.equals(this.toolExecutionRequest, that.toolExecutionRequest) && Objects.equals(this.invocationContext, that.invocationContext);
    }

    public int hashCode() {
        return Objects.hash(this.toolExecutionRequest, this.invocationContext);
    }

    public String toString() {
        return "ToolErrorContext{toolExecutionRequest=" + String.valueOf(this.toolExecutionRequest) + ", invocationContext=" + String.valueOf(this.invocationContext) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ToolExecutionRequest toolExecutionRequest;
        private InvocationContext invocationContext;

        public Builder toolExecutionRequest(ToolExecutionRequest toolExecutionRequest) {
            this.toolExecutionRequest = toolExecutionRequest;
            return this;
        }

        public Builder invocationContext(InvocationContext invocationContext) {
            this.invocationContext = invocationContext;
            return this;
        }

        public ToolErrorContext build() {
            return new ToolErrorContext(this);
        }
    }
}

