/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.internal.JsonParsingUtils;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.output.OutputParser;
import dev.langchain4j.service.output.ParsingUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class PojoOutputParser<T>
implements OutputParser<T> {
    private final Class<T> type;

    PojoOutputParser(Class<T> type) {
        this.type = type;
    }

    @Override
    public T parse(String text) {
        if (Utils.isNullOrBlank(text)) {
            throw ParsingUtils.outputParsingException(text, this.type);
        }
        try {
            return JsonParsingUtils.extractAndParseJson(text, this.type).value();
        }
        catch (Exception e) {
            throw ParsingUtils.outputParsingException(text, this.type.getTypeName(), e);
        }
    }

    @Override
    public Optional<JsonSchema> jsonSchema() {
        JsonSchema jsonSchema = JsonSchema.builder().name(this.type.getSimpleName()).rootElement(JsonSchemaElementUtils.jsonObjectOrReferenceSchemaFrom(this.type, null, false, new LinkedHashMap(), true)).build();
        return Optional.of(jsonSchema);
    }

    @Override
    public String formatInstructions() {
        String jsonStructure = PojoOutputParser.jsonStructure(this.type, new HashSet());
        this.validateJsonStructure(jsonStructure, this.type);
        return "\nYou must answer strictly in the following JSON format: " + jsonStructure;
    }

    private static String jsonStructure(Class<?> type, Set<Class<?>> visited) {
        StringBuilder jsonSchema = new StringBuilder();
        jsonSchema.append("{\n");
        for (Field field : type.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals("__$hits$__") || Modifier.isStatic(field.getModifiers())) continue;
            jsonSchema.append(String.format("\"%s\": (%s),\n", name, PojoOutputParser.descriptionFor(field, visited)));
        }
        int trailingCommaIndex = jsonSchema.lastIndexOf(",");
        if (trailingCommaIndex > 0) {
            jsonSchema.delete(trailingCommaIndex, trailingCommaIndex + 1);
        }
        jsonSchema.append("}");
        return jsonSchema.toString();
    }

    private static String descriptionFor(Field field, Set<Class<?>> visited) {
        Description fieldDescription = field.getAnnotation(Description.class);
        if (fieldDescription == null) {
            return "type: " + PojoOutputParser.typeOf(field, visited);
        }
        return String.join((CharSequence)" ", fieldDescription.value()) + "; type: " + PojoOutputParser.typeOf(field, visited);
    }

    private static String typeOf(Field field, Set<Class<?>> visited) {
        return PojoOutputParser.typeOf(field.getGenericType(), visited);
    }

    private static String typeOf(Type type, Set<Class<?>> visited) {
        if (type instanceof ParameterizedType) {
            Class rawClass;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && ((rawClass = (Class)rawType) == List.class || rawClass == Set.class)) {
                return String.format("array of %s", PojoOutputParser.typeOf(parameterizedType.getActualTypeArguments()[0], visited));
            }
        } else if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return String.format("array of %s", PojoOutputParser.typeOf(clazz.getComponentType(), visited));
            }
            if (clazz.isEnum()) {
                return "enum, must be one of " + String.valueOf(Arrays.stream(clazz.getEnumConstants()).map(e -> ((Enum)e).name()).toList());
            }
            return PojoOutputParser.simpleNameOrJsonStructure(clazz, visited);
        }
        return PojoOutputParser.simpleTypeName(type);
    }

    private static String simpleNameOrJsonStructure(Class<?> structured, Set<Class<?>> visited) {
        String simpleTypeName = PojoOutputParser.simpleTypeName(structured);
        if (structured.getPackage() == null || structured.getPackage().getName().startsWith("java.") || visited.contains(structured)) {
            return simpleTypeName;
        }
        visited.add(structured);
        return simpleTypeName + ": " + PojoOutputParser.jsonStructure(structured, visited);
    }

    private static String simpleTypeName(Type type) {
        return switch (type.getTypeName()) {
            case "java.lang.String" -> "string";
            case "java.lang.Integer", "int" -> "integer";
            case "java.lang.Boolean", "boolean" -> "boolean";
            case "java.lang.Float", "float" -> "float";
            case "java.lang.Double", "double" -> "double";
            case "java.util.Date", "java.time.LocalDate" -> "date string (2023-12-31)";
            case "java.time.LocalTime" -> "time string (23:59:59)";
            case "java.time.LocalDateTime" -> "date-time string (2023-12-31T23:59:59)";
            default -> type.getTypeName();
        };
    }

    private void validateJsonStructure(String jsonStructure, Type returnType) {
        if (jsonStructure.replaceAll("\\s", "").equals("{}")) {
            if (returnType.toString().contains("reactor.core.publisher.Flux")) {
                throw IllegalConfigurationException.illegalConfiguration("Please import langchain4j-reactor module if you wish to use Flux<String> as a method return type");
            }
            throw IllegalConfigurationException.illegalConfiguration("Illegal method return type: " + String.valueOf(returnType));
        }
    }
}

