/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.guardrail.ChatExecutor;
import dev.langchain4j.guardrail.GuardrailRequestParams;
import dev.langchain4j.guardrail.InputGuardrailRequest;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.internal.DefaultExecutorProvider;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.invocation.InvocationParameters;
import dev.langchain4j.invocation.LangChain4jManaged;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.observability.api.event.AiServiceCompletedEvent;
import dev.langchain4j.observability.api.event.AiServiceErrorEvent;
import dev.langchain4j.observability.api.event.AiServiceResponseReceivedEvent;
import dev.langchain4j.observability.api.event.AiServiceStartedEvent;
import dev.langchain4j.rag.AugmentationRequest;
import dev.langchain4j.rag.AugmentationResult;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServiceParamsUtil;
import dev.langchain4j.service.AiServiceTokenStream;
import dev.langchain4j.service.AiServiceTokenStreamParameters;
import dev.langchain4j.service.AiServiceValidation;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.InternalReflectionVariableResolver;
import dev.langchain4j.service.MemoryId;
import dev.langchain4j.service.Moderate;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.TypeUtils;
import dev.langchain4j.service.UserMessage;
import dev.langchain4j.service.UserName;
import dev.langchain4j.service.V;
import dev.langchain4j.service.guardrail.GuardrailService;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import dev.langchain4j.service.output.ServiceOutputParser;
import dev.langchain4j.service.tool.ToolServiceContext;
import dev.langchain4j.service.tool.ToolServiceResult;
import dev.langchain4j.spi.ServiceHelper;
import dev.langchain4j.spi.services.TokenStreamAdapter;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class DefaultAiServices<T>
extends AiServices<T> {
    private final ServiceOutputParser serviceOutputParser = new ServiceOutputParser();
    private final Collection<TokenStreamAdapter> tokenStreamAdapters = ServiceHelper.loadFactories(TokenStreamAdapter.class);
    private static final Set<Class<? extends Annotation>> VALID_PARAM_ANNOTATIONS = Set.of(UserMessage.class, V.class, MemoryId.class, UserName.class);

    DefaultAiServices(AiServiceContext context) {
        super(context);
    }

    protected void validate() {
        this.performBasicValidation();
        AiServiceValidation.validate(this.context);
    }

    private Object handleChatMemoryAccess(Method method, Object[] args) {
        return switch (method.getName()) {
            case "getChatMemory" -> this.context.chatMemoryService.getChatMemory(args[0]);
            case "evictChatMemory" -> this.context.chatMemoryService.evictChatMemory(args[0]) != null;
            default -> throw new UnsupportedOperationException("Unknown method on ChatMemoryAccess class : " + method.getName());
        };
    }

    @Override
    public T build() {
        this.validate();
        Object proxyInstance = Proxy.newProxyInstance(this.context.aiServiceClass.getClassLoader(), new Class[]{this.context.aiServiceClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.isDefault()) {
                    return InvocationHandler.invokeDefault(proxy, method, args);
                }
                if (method.getDeclaringClass() == Object.class) {
                    switch (method.getName()) {
                        case "equals": {
                            return proxy == args[0];
                        }
                        case "hashCode": {
                            return System.identityHashCode(proxy);
                        }
                        case "toString": {
                            return DefaultAiServices.this.context.aiServiceClass.getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
                        }
                    }
                    throw new IllegalStateException("Unexpected Object method: " + String.valueOf(method));
                }
                if (method.getDeclaringClass() == ChatMemoryAccess.class) {
                    return DefaultAiServices.this.handleChatMemoryAccess(method, args);
                }
                AiServiceValidation.validateParameters(DefaultAiServices.this.context.aiServiceClass, method);
                InvocationParameters invocationParameters = AiServiceParamsUtil.findArgumentOfType(InvocationParameters.class, args, method.getParameters()).orElseGet(InvocationParameters::new);
                Object invocationContext = InvocationContext.builder().invocationId(UUID.randomUUID()).interfaceName(DefaultAiServices.this.context.aiServiceClass.getName()).methodName(method.getName()).methodArguments(args != null ? Arrays.asList(args) : List.of()).chatMemoryId(DefaultAiServices.findMemoryId(method, args).orElse("default")).invocationParameters(invocationParameters).managedParameters(LangChain4jManaged.current()).timestampNow().build();
                try {
                    return this.invoke(method, args, (InvocationContext)invocationContext);
                }
                catch (Exception ex) {
                    DefaultAiServices.this.context.eventListenerRegistrar.fireEvent(AiServiceErrorEvent.builder().invocationContext((InvocationContext)invocationContext).error(ex).build());
                    throw ex;
                }
            }

            public Object invoke(Method method, Object[] args, InvocationContext invocationContext) {
                Optional<List<Content>> maybeContents;
                Object memoryId = invocationContext.chatMemoryId();
                ChatMemory chatMemory = DefaultAiServices.this.context.hasChatMemory() ? DefaultAiServices.this.context.chatMemoryService.getOrCreateChatMemory(memoryId) : null;
                Optional<dev.langchain4j.data.message.SystemMessage> systemMessage = DefaultAiServices.this.prepareSystemMessage(memoryId, method, args);
                String userMessageTemplate = DefaultAiServices.this.getUserMessageTemplate(memoryId, method, args);
                Map<String, Object> variables = InternalReflectionVariableResolver.findTemplateVariables(userMessageTemplate, method, args);
                dev.langchain4j.data.message.UserMessage originalUserMessage = DefaultAiServices.prepareUserMessage(method, args, userMessageTemplate, variables);
                DefaultAiServices.this.context.eventListenerRegistrar.fireEvent(AiServiceStartedEvent.builder().invocationContext(invocationContext).systemMessage(systemMessage).userMessage(originalUserMessage).build());
                dev.langchain4j.data.message.UserMessage userMessageForAugmentation = originalUserMessage;
                AugmentationResult augmentationResult = null;
                if (DefaultAiServices.this.context.retrievalAugmentor != null) {
                    List<ChatMessage> chatMemoryMessages = chatMemory != null ? chatMemory.messages() : null;
                    Metadata metadata = Metadata.builder().chatMessage(userMessageForAugmentation).systemMessage(systemMessage.orElse(null)).chatMemory(chatMemoryMessages).invocationContext(invocationContext).build();
                    AugmentationRequest augmentationRequest = new AugmentationRequest(userMessageForAugmentation, metadata);
                    augmentationResult = DefaultAiServices.this.context.retrievalAugmentor.augment(augmentationRequest);
                    userMessageForAugmentation = (dev.langchain4j.data.message.UserMessage)augmentationResult.chatMessage();
                }
                GuardrailRequestParams commonGuardrailParam = GuardrailRequestParams.builder().chatMemory(chatMemory).augmentationResult(augmentationResult).userMessageTemplate(userMessageTemplate).invocationContext(invocationContext).aiServiceListenerRegistrar(DefaultAiServices.this.context.eventListenerRegistrar).variables(variables).build();
                dev.langchain4j.data.message.UserMessage userMessage = DefaultAiServices.this.invokeInputGuardrails(DefaultAiServices.this.context.guardrailService(), method, userMessageForAugmentation, commonGuardrailParam);
                Class<?> returnType = DefaultAiServices.this.context.returnType != null ? DefaultAiServices.this.context.returnType : method.getGenericReturnType();
                boolean streaming = returnType == TokenStream.class || this.canAdaptTokenStreamTo(returnType);
                boolean supportsJsonSchema = this.supportsJsonSchema();
                Optional<Object> jsonSchema = Optional.empty();
                boolean returnsImage = 1.isImage(returnType);
                if (supportsJsonSchema && !streaming && !returnsImage) {
                    jsonSchema = DefaultAiServices.this.serviceOutputParser.jsonSchema(returnType);
                }
                if (!(supportsJsonSchema && !jsonSchema.isEmpty() || streaming || returnsImage)) {
                    userMessage = this.appendOutputFormatInstructions(returnType, userMessage);
                }
                if ((maybeContents = DefaultAiServices.findContents(method, args)).isPresent()) {
                    ArrayList<Content> allContents = new ArrayList<Content>();
                    for (Content content : maybeContents.get()) {
                        if (content == null) {
                            allContents.addAll(userMessage.contents());
                            continue;
                        }
                        allContents.add(content);
                    }
                    userMessage = userMessage.toBuilder().contents(allContents).build();
                }
                ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
                if (DefaultAiServices.this.context.hasChatMemory()) {
                    systemMessage.ifPresent(chatMemory::add);
                    messages.addAll(chatMemory.messages());
                    if (DefaultAiServices.this.context.storeRetrievedContentInChatMemory) {
                        chatMemory.add(userMessage);
                    } else {
                        chatMemory.add(originalUserMessage);
                    }
                    messages.add(userMessage);
                } else {
                    systemMessage.ifPresent(messages::add);
                    messages.add(userMessage);
                }
                Future<Moderation> moderationFuture = this.triggerModerationIfNeeded(method, messages);
                ToolServiceContext toolServiceContext = DefaultAiServices.this.context.toolService.createContext(invocationContext, userMessage);
                if (streaming) {
                    AiServiceTokenStreamParameters tokenStreamParameters = AiServiceTokenStreamParameters.builder().messages(messages).toolSpecifications(toolServiceContext.toolSpecifications()).toolExecutors(toolServiceContext.toolExecutors()).toolArgumentsErrorHandler(DefaultAiServices.this.context.toolService.argumentsErrorHandler()).toolExecutionErrorHandler(DefaultAiServices.this.context.toolService.executionErrorHandler()).toolExecutor(DefaultAiServices.this.context.toolService.executor()).retrievedContents(augmentationResult != null ? augmentationResult.contents() : null).context(DefaultAiServices.this.context).invocationContext(invocationContext).commonGuardrailParams(commonGuardrailParam).methodKey(method).build();
                    AiServiceTokenStream tokenStream = new AiServiceTokenStream(tokenStreamParameters);
                    if (returnType == TokenStream.class) {
                        return tokenStream;
                    }
                    return this.adapt(tokenStream, returnType);
                }
                ResponseFormat responseFormat = null;
                if (supportsJsonSchema && jsonSchema.isPresent()) {
                    responseFormat = ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema((JsonSchema)jsonSchema.get()).build();
                }
                ChatRequestParameters parameters = AiServiceParamsUtil.chatRequestParameters(method, args, toolServiceContext, responseFormat);
                ChatRequest chatRequest = DefaultAiServices.this.context.chatRequestTransformer.apply(ChatRequest.builder().messages(messages).parameters(parameters).build(), memoryId);
                ChatExecutor chatExecutor = ChatExecutor.builder(DefaultAiServices.this.context.chatModel).chatRequest(chatRequest).invocationContext(invocationContext).eventListenerRegistrar(DefaultAiServices.this.context.eventListenerRegistrar).build();
                ChatResponse chatResponse = chatExecutor.execute();
                DefaultAiServices.this.context.eventListenerRegistrar.fireEvent(AiServiceResponseReceivedEvent.builder().invocationContext(invocationContext).response(chatResponse).request(chatRequest).build());
                AiServices.verifyModerationIfNeeded(moderationFuture);
                boolean isReturnTypeResult = TypeUtils.typeHasRawClass(returnType, Result.class);
                ToolServiceResult toolServiceResult = DefaultAiServices.this.context.toolService.executeInferenceAndToolsLoop(DefaultAiServices.this.context, memoryId, chatResponse, parameters, messages, chatMemory, invocationContext, toolServiceContext, isReturnTypeResult);
                if (toolServiceResult.immediateToolReturn() && isReturnTypeResult) {
                    Result<Object> result = Result.builder().content(null).tokenUsage(toolServiceResult.aggregateTokenUsage()).sources(augmentationResult == null ? null : augmentationResult.contents()).finishReason(FinishReason.TOOL_EXECUTION).toolExecutions(toolServiceResult.toolExecutions()).intermediateResponses(toolServiceResult.intermediateResponses()).finalResponse(toolServiceResult.finalResponse()).build();
                    return this.fireEventAndReturn(invocationContext, result);
                }
                ChatResponse aggregateResponse = toolServiceResult.aggregateResponse();
                Object response = DefaultAiServices.this.invokeOutputGuardrails(DefaultAiServices.this.context.guardrailService(), method, aggregateResponse, chatExecutor, commonGuardrailParam);
                if (response != null) {
                    if (returnsImage && response instanceof ChatResponse) {
                        ChatResponse cResponse = (ChatResponse)response;
                        return this.fireEventAndReturn(invocationContext, 1.parseImages(cResponse, returnType));
                    }
                    if (TypeUtils.typeHasRawClass(returnType, response.getClass())) {
                        return this.fireEventAndReturn(invocationContext, response);
                    }
                }
                Result<Object> parsedResponse = DefaultAiServices.this.serviceOutputParser.parse((ChatResponse)response, returnType);
                Result<Object> actualResponse = isReturnTypeResult ? Result.builder().content(parsedResponse).tokenUsage(toolServiceResult.aggregateTokenUsage()).sources(augmentationResult == null ? null : augmentationResult.contents()).finishReason(toolServiceResult.finalResponse().finishReason()).toolExecutions(toolServiceResult.toolExecutions()).intermediateResponses(toolServiceResult.intermediateResponses()).finalResponse(toolServiceResult.finalResponse()).build() : parsedResponse;
                return this.fireEventAndReturn(invocationContext, actualResponse);
            }

            private Object fireEventAndReturn(InvocationContext invocationContext, Object result) {
                DefaultAiServices.this.context.eventListenerRegistrar.fireEvent(AiServiceCompletedEvent.builder().invocationContext(invocationContext).result(result).build());
                return result;
            }

            private static boolean isImage(Type returnType) {
                Class<?> rawReturnType = TypeUtils.getRawClass(returnType);
                if (TypeUtils.isImageType(rawReturnType)) {
                    return true;
                }
                if (Collection.class.isAssignableFrom(rawReturnType)) {
                    Class<?> genericParam = TypeUtils.resolveFirstGenericParameterClass(returnType);
                    return genericParam != null && TypeUtils.isImageType(genericParam);
                }
                return false;
            }

            private static Object parseImages(ChatResponse response, Type returnType) {
                List<Image> images = response.aiMessage().images();
                Class<?> rawReturnType = TypeUtils.getRawClass(returnType);
                if (1.isImage(rawReturnType)) {
                    if (rawReturnType == ImageContent.class) {
                        List<ImageContent> imageContents = 1.toImageContents(images);
                        return imageContents.isEmpty() ? null : imageContents.get(0);
                    }
                    if (rawReturnType == Image.class) {
                        return images.isEmpty() ? null : images.get(0);
                    }
                }
                if (Collection.class.isAssignableFrom(rawReturnType)) {
                    Class<?> genericParam = TypeUtils.resolveFirstGenericParameterClass(returnType);
                    if (genericParam == ImageContent.class) {
                        return 1.toImageContents(images);
                    }
                    if (genericParam == Image.class) {
                        return images;
                    }
                }
                throw new UnsupportedOperationException("Unsupported return type " + String.valueOf(rawReturnType));
            }

            private static List<ImageContent> toImageContents(List<Image> images) {
                return images.stream().map(ImageContent::from).toList();
            }

            private boolean canAdaptTokenStreamTo(Type returnType) {
                for (TokenStreamAdapter tokenStreamAdapter : DefaultAiServices.this.tokenStreamAdapters) {
                    if (!tokenStreamAdapter.canAdaptTokenStreamTo(returnType)) continue;
                    return true;
                }
                return false;
            }

            private Object adapt(TokenStream tokenStream, Type returnType) {
                for (TokenStreamAdapter tokenStreamAdapter : DefaultAiServices.this.tokenStreamAdapters) {
                    if (!tokenStreamAdapter.canAdaptTokenStreamTo(returnType)) continue;
                    return tokenStreamAdapter.adapt(tokenStream);
                }
                throw new IllegalStateException("Can't find suitable TokenStreamAdapter");
            }

            private boolean supportsJsonSchema() {
                return DefaultAiServices.this.context.chatModel != null && DefaultAiServices.this.context.chatModel.supportedCapabilities().contains((Object)Capability.RESPONSE_FORMAT_JSON_SCHEMA);
            }

            private dev.langchain4j.data.message.UserMessage appendOutputFormatInstructions(Type returnType, dev.langchain4j.data.message.UserMessage userMessage) {
                String outputFormatInstructions = DefaultAiServices.this.serviceOutputParser.outputFormatInstructions(returnType);
                if (Utils.isNullOrEmpty(outputFormatInstructions)) {
                    return userMessage;
                }
                ArrayList<Content> contents = new ArrayList<Content>(userMessage.contents());
                boolean appended = false;
                for (int i = contents.size() - 1; i >= 0; --i) {
                    Object e = contents.get(i);
                    if (!(e instanceof TextContent)) continue;
                    TextContent lastTextContent = (TextContent)e;
                    String newText = lastTextContent.text() + outputFormatInstructions;
                    contents.set(i, TextContent.from(newText));
                    appended = true;
                    break;
                }
                if (!appended) {
                    contents.add(TextContent.from(outputFormatInstructions));
                }
                return userMessage.toBuilder().contents(contents).build();
            }

            private Future<Moderation> triggerModerationIfNeeded(Method method, List<ChatMessage> messages) {
                if (method.isAnnotationPresent(Moderate.class)) {
                    ExecutorService executor = DefaultExecutorProvider.getDefaultExecutorService();
                    return executor.submit(() -> {
                        List<ChatMessage> messagesToModerate = AiServices.removeToolMessages(messages);
                        return DefaultAiServices.this.context.moderationModel.moderate(messagesToModerate).content();
                    });
                }
                return null;
            }
        });
        return (T)proxyInstance;
    }

    private dev.langchain4j.data.message.UserMessage invokeInputGuardrails(GuardrailService guardrailService, Method method, dev.langchain4j.data.message.UserMessage userMessage, GuardrailRequestParams commonGuardrailParams) {
        if (guardrailService.hasInputGuardrails(method)) {
            InputGuardrailRequest inputGuardrailRequest = InputGuardrailRequest.builder().userMessage(userMessage).commonParams(commonGuardrailParams).build();
            return guardrailService.executeGuardrails(method, inputGuardrailRequest);
        }
        return userMessage;
    }

    private <T> T invokeOutputGuardrails(GuardrailService guardrailService, Method method, ChatResponse responseFromLLM, ChatExecutor chatExecutor, GuardrailRequestParams commonGuardrailParams) {
        if (guardrailService.hasOutputGuardrails(method)) {
            OutputGuardrailRequest outputGuardrailRequest = OutputGuardrailRequest.builder().responseFromLLM(responseFromLLM).chatExecutor(chatExecutor).requestParams(commonGuardrailParams).build();
            return guardrailService.executeGuardrails(method, outputGuardrailRequest);
        }
        return (T)responseFromLLM;
    }

    private Optional<dev.langchain4j.data.message.SystemMessage> prepareSystemMessage(Object memoryId, Method method, Object[] args) {
        return this.findSystemMessageTemplate(memoryId, method).map(systemMessageTemplate -> PromptTemplate.from(systemMessageTemplate).apply(InternalReflectionVariableResolver.findTemplateVariables(systemMessageTemplate, method, args)).toSystemMessage());
    }

    private Optional<String> findSystemMessageTemplate(Object memoryId, Method method) {
        SystemMessage annotation = method.getAnnotation(SystemMessage.class);
        if (annotation != null) {
            return Optional.of(DefaultAiServices.getTemplate(method, "System", annotation.fromResource(), annotation.value(), annotation.delimiter()));
        }
        return this.context.systemMessageProvider.apply(memoryId);
    }

    private static dev.langchain4j.data.message.UserMessage prepareUserMessage(Method method, Object[] args, String userMessageTemplate, Map<String, Object> variables) {
        Optional<String> maybeUserName = DefaultAiServices.findUserName(method.getParameters(), args);
        if (userMessageTemplate.isEmpty()) {
            ArrayList<Content> contents = new ArrayList<Content>();
            for (Object arg : args) {
                if (arg instanceof Content) {
                    Content content = (Content)arg;
                    contents.add(content);
                    continue;
                }
                if (!DefaultAiServices.isListOfContents(arg)) continue;
                contents.addAll((List)arg);
            }
            if (!contents.isEmpty()) {
                return maybeUserName.map(userName -> dev.langchain4j.data.message.UserMessage.from(userName, contents)).orElseGet(() -> dev.langchain4j.data.message.UserMessage.from(contents));
            }
            throw IllegalConfigurationException.illegalConfiguration("Error: The method '%s' does not have a user message defined.", method.getName());
        }
        Prompt prompt = PromptTemplate.from(userMessageTemplate).apply(variables);
        return maybeUserName.map(userName -> dev.langchain4j.data.message.UserMessage.from(userName, prompt.text())).orElseGet(prompt::toUserMessage);
    }

    private String getUserMessageTemplate(Object memoryId, Method method, Object[] args) {
        Optional<String> templateFromMethodAnnotation = DefaultAiServices.findUserMessageTemplateFromMethodAnnotation(method);
        Optional<String> templateFromParameterAnnotation = DefaultAiServices.findUserMessageTemplateFromAnnotatedParameter(method.getParameters(), args);
        if (templateFromMethodAnnotation.isPresent() && templateFromParameterAnnotation.isPresent()) {
            throw IllegalConfigurationException.illegalConfiguration("Error: The method '%s' has multiple @UserMessage annotations. Please use only one.", method.getName());
        }
        if (templateFromMethodAnnotation.isPresent()) {
            return templateFromMethodAnnotation.get();
        }
        if (templateFromParameterAnnotation.isPresent()) {
            return templateFromParameterAnnotation.get();
        }
        Optional<String> templateFromTheOnlyArgument = DefaultAiServices.findUserMessageTemplateFromTheOnlyArgument(method.getParameters(), args);
        if (templateFromTheOnlyArgument.isPresent()) {
            return templateFromTheOnlyArgument.get();
        }
        if (DefaultAiServices.hasContentArgument(method, args)) {
            return "";
        }
        return this.context.userMessageProvider.apply(memoryId).orElseThrow(() -> IllegalConfigurationException.illegalConfiguration("Error: The method '%s' does not have a user message defined.", method.getName()));
    }

    private static boolean hasContentArgument(Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(UserMessage.class) || !(args[i] instanceof Content) && !DefaultAiServices.isListOfContents(args[i])) continue;
            return true;
        }
        if (parameters.length == 1 && !DefaultAiServices.hasAnyValidAnnotation(parameters[0])) {
            return args[0] instanceof Content || DefaultAiServices.isListOfContents(args[0]);
        }
        return false;
    }

    private static Optional<String> findUserMessageTemplateFromMethodAnnotation(Method method) {
        return Optional.ofNullable(method.getAnnotation(UserMessage.class)).map(a -> DefaultAiServices.getTemplate(method, "User", a.fromResource(), a.value(), a.delimiter()));
    }

    private static Optional<String> findUserMessageTemplateFromAnnotatedParameter(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(UserMessage.class) || args[i] instanceof Content || DefaultAiServices.isListOfContents(args[i])) continue;
            return Optional.of(InternalReflectionVariableResolver.asString(args[i]));
        }
        return Optional.empty();
    }

    private static boolean hasAnyValidAnnotation(Parameter parameter) {
        for (Class<? extends Annotation> a : VALID_PARAM_ANNOTATIONS) {
            if (parameter.getAnnotation(a) == null) continue;
            return true;
        }
        return false;
    }

    private static Optional<String> findUserMessageTemplateFromTheOnlyArgument(Parameter[] parameters, Object[] args) {
        if (parameters != null && parameters.length == 1 && !DefaultAiServices.hasAnyValidAnnotation(parameters[0])) {
            if (args[0] instanceof Content || DefaultAiServices.isListOfContents(args[0])) {
                return Optional.empty();
            }
            return Optional.of(InternalReflectionVariableResolver.asString(args[0]));
        }
        return Optional.empty();
    }

    private static Optional<String> findUserName(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(UserName.class)) continue;
            return Optional.of(args[i].toString());
        }
        return Optional.empty();
    }

    private static Optional<List<Content>> findContents(Method method, Object[] args) {
        ArrayList<Content> contents = new ArrayList<Content>();
        if (DefaultAiServices.findUserMessageTemplateFromMethodAnnotation(method).isPresent()) {
            contents.add(null);
        }
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(UserMessage.class)) continue;
            if (args[i] instanceof Content) {
                contents.add((Content)args[i]);
                continue;
            }
            if (DefaultAiServices.isListOfContents(args[i])) {
                contents.addAll((List)args[i]);
                continue;
            }
            contents.add(null);
        }
        if (contents.isEmpty() && parameters.length == 1 && !DefaultAiServices.hasAnyValidAnnotation(parameters[0])) {
            if (args[0] instanceof Content) {
                contents.add((Content)args[0]);
            } else if (DefaultAiServices.isListOfContents(args[0])) {
                contents.addAll((List)args[0]);
            }
        }
        if (contents.stream().filter(Objects::isNull).count() > 1L) {
            throw IllegalConfigurationException.illegalConfiguration("Error: The method '%s' has multiple @UserMessage for text content. Please use only one.", method.getName());
        }
        return contents.isEmpty() ? Optional.empty() : Optional.of(contents);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isListOfContents(Object o) {
        if (!(o instanceof List)) return false;
        List list = (List)o;
        if (!list.stream().allMatch(Content.class::isInstance)) return false;
        return true;
    }

    private static String getTemplate(Method method, String type, String resource, String[] value, String delimiter) {
        String messageTemplate;
        if (!resource.trim().isEmpty()) {
            messageTemplate = DefaultAiServices.getResourceText(method.getDeclaringClass(), resource);
            if (messageTemplate == null) {
                throw IllegalConfigurationException.illegalConfiguration("@%sMessage's resource '%s' not found", type, resource);
            }
        } else {
            messageTemplate = String.join((CharSequence)delimiter, value);
        }
        if (messageTemplate.trim().isEmpty()) {
            throw IllegalConfigurationException.illegalConfiguration("@%sMessage's template cannot be empty", type);
        }
        return messageTemplate;
    }

    private static String getResourceText(Class<?> clazz, String resource) {
        InputStream inputStream = clazz.getResourceAsStream(resource);
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream("/" + resource);
        }
        return DefaultAiServices.getText(inputStream);
    }

    private static String getText(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try (Scanner scanner = new Scanner(inputStream);){
            Scanner s = scanner.useDelimiter("\\A");
            try {
                String string;
                String string2 = string = s.hasNext() ? s.next() : "";
                if (s != null) {
                    s.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static Optional<Object> findMemoryId(Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(MemoryId.class)) continue;
            Object memoryId = args[i];
            if (memoryId == null) {
                throw Exceptions.illegalArgument("The value of parameter '%s' annotated with @MemoryId in method '%s' must not be null", parameters[i].getName(), method.getName());
            }
            return Optional.of(memoryId);
        }
        return Optional.empty();
    }
}

