/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import java.util.Collection;

public class ValidationUtils {
    public static <T> T ensureNotNull(T object, String name) {
        return ValidationUtils.ensureNotNull(object, "%s cannot be null", name);
    }

    public static <T> T ensureNotNull(T object, String format, Object ... args) {
        if (object == null) {
            throw Exceptions.illegalArgument(format, args);
        }
        return object;
    }

    public static <T extends Collection<?>> T ensureNotEmpty(T collection, String name) {
        if (Utils.isNullOrEmpty(collection)) {
            throw Exceptions.illegalArgument("%s cannot be null or empty", name);
        }
        return collection;
    }

    public static <T> T[] ensureNotEmpty(T[] array, String format, Object ... args) {
        if (array == null || array.length == 0) {
            throw Exceptions.illegalArgument(format, args);
        }
        return array;
    }

    public static String ensureNotBlank(String string, String name) {
        return ValidationUtils.ensureNotBlank(string, "%s cannot be null or blank", name);
    }

    public static String ensureNotBlank(String string, String format, Object ... args) {
        if (Utils.isNullOrBlank(string)) {
            throw Exceptions.illegalArgument(format, args);
        }
        return string;
    }
}

