/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static <T> T getOrDefault(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static <T> List<T> getOrDefault(List<T> list, List<T> defaultList) {
        return Utils.isNullOrEmpty(list) ? defaultList : list;
    }

    public static boolean isNullOrBlank(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    private static MessageDigest getSha256Instance() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String generateUUIDFrom(String input) {
        byte[] hashBytes = Utils.getSha256Instance().digest(input.getBytes(StandardCharsets.UTF_8));
        String hexFormat = HexFormat.of().formatHex(hashBytes);
        return UUID.nameUUIDFromBytes(hexFormat.getBytes(StandardCharsets.UTF_8)).toString();
    }

    public static String quoted(Object object) {
        if (object == null) {
            return "null";
        }
        return "\"" + String.valueOf(object) + "\"";
    }

    public static <T> Set<T> copy(Set<T> set) {
        if (set == null) {
            return Set.of();
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> List<T> copy(List<T> list) {
        if (list == null) {
            return List.of();
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> mutableCopy(List<T> list) {
        if (list == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(list);
    }

    public static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map == null) {
            return Map.of();
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mutableCopy(Map<K, V> map) {
        if (map == null) {
            return new HashMap();
        }
        return new HashMap<K, V>(map);
    }

    public static Optional<Method> getAnnotatedMethod(Method method, Class<? extends Annotation> annotation) {
        if (method.isAnnotationPresent(annotation)) {
            return Optional.of(method);
        }
        if (Proxy.isProxyClass(method.getDeclaringClass())) {
            for (Class<?> iface : method.getDeclaringClass().getInterfaces()) {
                try {
                    Method interfaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                    if (interfaceMethod.isAnnotationPresent(annotation)) {
                        return Optional.of(interfaceMethod);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }
}

