/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import java.util.Iterator;

public class ForLoop
implements Iterator<Object> {
    private int index = -1;
    private int counter = 0;
    private int revindex = Integer.MIN_VALUE;
    private int revcounter = Integer.MIN_VALUE;
    private int length = Integer.MIN_VALUE;
    private boolean first = true;
    private boolean last;
    private final Iterator<?> it;

    public ForLoop(Iterator<?> ite, int len) {
        this.length = len;
        if (len < 2) {
            this.revindex = 1;
            this.revcounter = 2;
            this.last = true;
        } else {
            this.revindex = len;
            this.revcounter = len + 1;
            this.last = false;
        }
        this.it = ite;
    }

    public ForLoop(Iterator<?> ite) {
        this.it = ite;
        if (this.it.hasNext()) {
            this.last = false;
        } else {
            this.length = 0;
            this.revindex = 1;
            this.revcounter = 2;
            this.last = true;
        }
    }

    @Override
    public Object next() {
        Object res;
        if (this.it.hasNext()) {
            ++this.index;
            ++this.counter;
            if (this.length != Integer.MIN_VALUE) {
                --this.revindex;
                --this.revcounter;
            }
            res = this.it.next();
            if (!this.it.hasNext()) {
                this.last = true;
                this.length = this.counter;
                this.revindex = 0;
                this.revcounter = 1;
            }
            if (this.index > 0) {
                this.first = false;
            }
        } else {
            res = null;
        }
        return res;
    }

    public int getIndex() {
        return this.index + 1;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "<ForLoop: " + this.length + ">";
    }
}

