/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.hubspot.jinjava.interpret.CannotReconstructValueException;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.LazyExpression;
import com.hubspot.jinjava.interpret.OneTimeReconstructible;
import com.hubspot.jinjava.interpret.RevertibleObject;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.objects.collections.PyList;
import com.hubspot.jinjava.objects.collections.PyMap;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EagerContextWatcher {
    public static EagerExecutionResult executeInChildContext(Function<JinjavaInterpreter, EagerExpressionResolver.EagerExpressionResult> function, JinjavaInterpreter interpreter, EagerChildContextConfig eagerChildContextConfig) {
        Map<String, Object> speculativeBindings;
        EagerExecutionResult initialResult;
        Set<String> metaContextVariables = interpreter.getContext().getMetaContextVariables();
        if (eagerChildContextConfig.checkForContextChanges) {
            Set<Map.Entry<String, Object>> entrySet = interpreter.getContext().entrySet();
            Map<String, Object> initiallyResolvedHashes = EagerContextWatcher.getInitiallyResolvedHashes(entrySet, metaContextVariables);
            Map<String, String> initiallyResolvedAsStrings = EagerContextWatcher.getInitiallyResolvedAsStrings(interpreter, entrySet, initiallyResolvedHashes);
            initialResult = EagerContextWatcher.applyFunction(function, interpreter, eagerChildContextConfig);
            speculativeBindings = EagerContextWatcher.getAllSpeculativeBindings(interpreter, eagerChildContextConfig, metaContextVariables, initiallyResolvedHashes, initiallyResolvedAsStrings, initialResult);
        } else {
            Set<String> ignoredKeys = EagerContextWatcher.getKeysToIgnore(interpreter, metaContextVariables, eagerChildContextConfig);
            initialResult = EagerContextWatcher.applyFunction(function, interpreter, eagerChildContextConfig);
            speculativeBindings = EagerContextWatcher.getBasicSpeculativeBindings(interpreter, eagerChildContextConfig, ignoredKeys, initialResult);
        }
        return new EagerExecutionResult(initialResult.getResult(), speculativeBindings);
    }

    private static EagerExecutionResult applyFunction(Function<JinjavaInterpreter, EagerExpressionResolver.EagerExpressionResult> function, JinjavaInterpreter interpreter, EagerChildContextConfig eagerChildContextConfig) {
        try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterNonStackingScope();){
            if (eagerChildContextConfig.forceDeferredExecutionMode) {
                interpreter.getContext().setDeferredExecutionMode(true);
            }
            interpreter.getContext().setPartialMacroEvaluation(eagerChildContextConfig.partialMacroEvaluation);
            EagerExecutionResult eagerExecutionResult = new EagerExecutionResult(function.apply(interpreter), eagerChildContextConfig.discardSessionBindings ? new HashMap() : interpreter.getContext().getSessionBindings());
            return eagerExecutionResult;
        }
    }

    private static Map<String, String> getInitiallyResolvedAsStrings(JinjavaInterpreter interpreter, Set<Map.Entry<String, Object>> entrySet, Map<String, Object> initiallyResolvedHashes) {
        HashMap<String, String> initiallyResolvedAsStrings = new HashMap<String, String>();
        Stream<Map.Entry> entryStream = (interpreter.getConfig().getExecutionMode().useEagerContextReverting() ? entrySet : interpreter.getContext().getCombinedScope().entrySet()).stream().filter(entry -> initiallyResolvedHashes.containsKey(entry.getKey())).filter(entry -> EagerExpressionResolver.isResolvableObject(entry.getValue(), 4, 400));
        entryStream.forEach(entry -> EagerContextWatcher.cacheRevertibleObject(interpreter, initiallyResolvedHashes, initiallyResolvedAsStrings, entry));
        return initiallyResolvedAsStrings;
    }

    private static Map<String, Object> getInitiallyResolvedHashes(Set<Map.Entry<String, Object>> entrySet, Set<String> metaContextVariables) {
        HashMap<String, Object> mapOfHashes = new HashMap<String, Object>();
        entrySet.stream().filter(entry -> !metaContextVariables.contains(entry.getKey())).filter(entry -> !(entry.getValue() instanceof DeferredValue) && entry.getValue() != null).forEach(entry -> mapOfHashes.put((String)entry.getKey(), EagerContextWatcher.getObjectOrHashCode(entry.getValue())));
        return mapOfHashes;
    }

    private static Set<String> getKeysToIgnore(JinjavaInterpreter interpreter, Set<String> metaContextVariables, EagerChildContextConfig eagerChildContextConfig) {
        return interpreter.getContext().isDeferredExecutionMode() && !eagerChildContextConfig.takeNewValue ? Stream.concat(metaContextVariables.stream(), interpreter.getContext().entrySet().stream().filter(entry -> entry.getValue() instanceof DeferredValue).map(Map.Entry::getKey)).collect(Collectors.toSet()) : metaContextVariables;
    }

    private static Map<String, Object> getBasicSpeculativeBindings(JinjavaInterpreter interpreter, EagerChildContextConfig eagerChildContextConfig, Set<String> ignoredKeys, EagerExecutionResult eagerExecutionResult) {
        if (!eagerChildContextConfig.takeNewValue) {
            eagerExecutionResult.getSpeculativeBindings().putAll(interpreter.getContext().getScope().entrySet().stream().filter(entry -> entry.getValue() instanceof OneTimeReconstructible && !((OneTimeReconstructible)entry.getValue()).isReconstructed()).peek(entry -> ((OneTimeReconstructible)entry.getValue()).setReconstructed(true)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return eagerExecutionResult.getSpeculativeBindings().entrySet().stream().filter(entry -> !ignoredKeys.contains(entry.getKey())).filter(entry -> !"loop".equals(entry.getKey())).map(entry -> {
            if (eagerExecutionResult.getResult().isFullyResolved() || eagerChildContextConfig.takeNewValue) {
                return entry;
            }
            Object contextValue = interpreter.getContext().get(entry.getKey());
            if (contextValue instanceof DeferredValue && ((DeferredValue)contextValue).getOriginalValue() != null) {
                if (!eagerChildContextConfig.takeNewValue && !EagerExpressionResolver.isResolvableObject(((DeferredValue)contextValue).getOriginalValue())) {
                    throw new CannotReconstructValueException((String)entry.getKey());
                }
                return new AbstractMap.SimpleImmutableEntry((String)entry.getKey(), contextValue);
            }
            return null;
        }).filter(Objects::nonNull).filter(entry -> entry.getValue() != null).filter(entry -> !EagerContextWatcher.isDeferredWithOriginalValueNull(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, Object> getAllSpeculativeBindings(JinjavaInterpreter interpreter, EagerChildContextConfig eagerChildContextConfig, Set<String> metaContextVariables, Map<String, Object> initiallyResolvedHashes, Map<String, String> initiallyResolvedAsStrings, EagerExecutionResult eagerExecutionResult) {
        Map<String, Object> speculativeBindings = eagerExecutionResult.getSpeculativeBindings().entrySet().stream().filter(entry -> entry.getValue() != null && !entry.getValue().equals(interpreter.getContext().get(entry.getKey()))).filter(entry -> !(interpreter.getContext().get(entry.getKey()) instanceof DeferredValue)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        speculativeBindings.putAll(initiallyResolvedHashes.keySet().stream().map(key -> new AbstractMap.SimpleImmutableEntry((String)key, interpreter.getContext().get(key))).filter(entry -> !Objects.equals(initiallyResolvedHashes.get(entry.getKey()), EagerContextWatcher.getObjectOrHashCode(entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, entry -> EagerContextWatcher.getOriginalValue(interpreter, eagerChildContextConfig, initiallyResolvedHashes, initiallyResolvedAsStrings, entry, eagerExecutionResult.getResult().isFullyResolved()))));
        speculativeBindings = speculativeBindings.entrySet().stream().filter(entry -> !metaContextVariables.contains(entry.getKey())).filter(entry -> entry.getValue() != null).filter(entry -> !EagerContextWatcher.isDeferredWithOriginalValueNull(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return speculativeBindings;
    }

    private static boolean isDeferredWithOriginalValueNull(Object value) {
        return value instanceof DeferredValue && ((DeferredValue)value).getOriginalValue() == null;
    }

    private static void cacheRevertibleObject(JinjavaInterpreter interpreter, Map<String, Object> initiallyResolvedHashes, Map<String, String> initiallyResolvedAsStrings, Map.Entry<String, Object> entry) {
        RevertibleObject revertibleObject = interpreter.getRevertibleObjects().get(entry.getKey());
        Object hashCode = initiallyResolvedHashes.get(entry.getKey());
        try {
            if (revertibleObject == null || !hashCode.equals(revertibleObject.getHashCode())) {
                revertibleObject = new RevertibleObject(hashCode, PyishObjectMapper.getAsPyishStringOrThrow(entry.getValue()));
                interpreter.getRevertibleObjects().put(entry.getKey(), revertibleObject);
            }
            revertibleObject.getPyishString().ifPresent(pyishString -> initiallyResolvedAsStrings.put((String)entry.getKey(), (String)pyishString));
        }
        catch (Exception e) {
            interpreter.getRevertibleObjects().put(entry.getKey(), new RevertibleObject(hashCode));
        }
    }

    private static Object getOriginalValue(JinjavaInterpreter interpreter, EagerChildContextConfig eagerChildContextConfig, Map<String, Object> initiallyResolvedHashes, Map<String, String> initiallyResolvedAsStrings, Map.Entry<String, Object> e, boolean isFullyResolved) {
        if (eagerChildContextConfig.takeNewValue || isFullyResolved) {
            return e.getValue();
        }
        if (e.getValue() instanceof DeferredValue && initiallyResolvedHashes.get(e.getKey()).equals(EagerContextWatcher.getObjectOrHashCode(((DeferredValue)e.getValue()).getOriginalValue()))) {
            return e.getValue();
        }
        if (initiallyResolvedAsStrings.containsKey(e.getKey())) {
            try {
                return interpreter.resolveELExpression(initiallyResolvedAsStrings.get(e.getKey()), interpreter.getLineNumber());
            }
            catch (DeferredValueException deferredValueException) {
                // empty catch block
            }
        }
        throw new CannotReconstructValueException(e.getKey());
    }

    private static Object getObjectOrHashCode(Object o) {
        if (o instanceof LazyExpression) {
            o = ((LazyExpression)o).get();
        }
        if (o instanceof PyList && !((PyList)o).toList().contains(o)) {
            return o.hashCode();
        }
        if (o instanceof PyMap && !((PyMap)o).toMap().containsValue(o)) {
            return o.hashCode() + ((PyMap)o).keySet().hashCode();
        }
        return o;
    }

    public static class EagerChildContextConfig {
        private final boolean takeNewValue;
        private final boolean discardSessionBindings;
        private final boolean partialMacroEvaluation;
        private final boolean checkForContextChanges;
        private final boolean forceDeferredExecutionMode;

        private EagerChildContextConfig(boolean takeNewValue, boolean discardSessionBindings, boolean partialMacroEvaluation, boolean checkForContextChanges, boolean forceDeferredExecutionMode) {
            this.takeNewValue = takeNewValue;
            this.discardSessionBindings = discardSessionBindings;
            this.partialMacroEvaluation = partialMacroEvaluation;
            this.checkForContextChanges = checkForContextChanges;
            this.forceDeferredExecutionMode = forceDeferredExecutionMode;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private boolean takeNewValue;
            private boolean discardSessionBindings;
            private boolean partialMacroEvaluation;
            private boolean checkForContextChanges;
            private boolean forceDeferredExecutionMode;

            private Builder() {
            }

            public Builder withTakeNewValue(boolean takeNewValue) {
                this.takeNewValue = takeNewValue;
                return this;
            }

            public Builder withPartialMacroEvaluation(boolean partialMacroEvaluation) {
                this.partialMacroEvaluation = partialMacroEvaluation;
                return this;
            }

            public Builder withCheckForContextChanges(boolean checkForContextChanges) {
                this.checkForContextChanges = checkForContextChanges;
                return this;
            }

            public Builder withForceDeferredExecutionMode(boolean forceDeferredExecutionMode) {
                this.forceDeferredExecutionMode = forceDeferredExecutionMode;
                return this;
            }

            public EagerChildContextConfig build() {
                return new EagerChildContextConfig(this.takeNewValue, this.discardSessionBindings, this.partialMacroEvaluation, this.checkForContextChanges, this.forceDeferredExecutionMode);
            }
        }
    }
}

