/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree;

import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.OutputTooBigException;
import com.hubspot.jinjava.lib.tag.FlexibleTag;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.output.OutputNode;
import com.hubspot.jinjava.tree.output.RenderedOutputNode;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;

public class TagNode
extends Node {
    private final Tag tag;
    private final TagToken master;
    private final String endName;

    public TagNode(Tag tag, TagToken token, TokenScannerSymbols symbols) {
        super(token, token.getLineNumber(), token.getStartPosition());
        this.master = token;
        this.tag = tag;
        this.endName = tag.getEndTagName();
    }

    @Override
    public OutputNode render(JinjavaInterpreter interpreter) {
        this.preProcess(interpreter);
        try {
            if (interpreter.getContext().isValidationMode() && !this.tag.isRenderedInValidationMode()) {
                RenderedOutputNode renderedOutputNode = new RenderedOutputNode("");
                return renderedOutputNode;
            }
            if (interpreter.getConfig().getExecutionMode().useEagerParser()) {
                interpreter.getContext().checkNumberOfDeferredTokens();
            }
            OutputNode outputNode = this.tag.interpretOutput(this, interpreter);
            return outputNode;
        }
        catch (DeferredValueException e) {
            interpreter.getContext().handleDeferredNode(this);
            RenderedOutputNode renderedOutputNode = new RenderedOutputNode(this.reconstructImage());
            return renderedOutputNode;
        }
        catch (InterpretException | InvalidArgumentException | InvalidInputException | OutputTooBigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InterpretException("Error rendering tag", (Throwable)e, this.master.getLineNumber(), this.master.getStartPosition());
        }
        finally {
            this.postProcess(interpreter);
        }
    }

    public String toString() {
        return this.master.toString();
    }

    @Override
    public String getName() {
        return this.master.getTagName();
    }

    public String getEndName() {
        return this.endName;
    }

    public String getHelpers() {
        return this.master.getHelpers();
    }

    public Tag getTag() {
        return this.tag;
    }

    @Override
    public String reconstructImage() {
        StringBuilder builder = new StringBuilder().append(this.master.getImage());
        for (Node n : this.getChildren()) {
            builder.append(n.reconstructImage());
        }
        if (this.getEndName() != null && (!(this.tag instanceof FlexibleTag) || ((FlexibleTag)((Object)this.tag)).hasEndTag(this.master))) {
            builder.append(this.reconstructEnd());
        }
        return builder.toString();
    }

    public String reconstructEnd() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSymbols().getExpressionStartWithTag());
        if (this.getChildren() != null && !this.getChildren().isEmpty() && this.getChildren().getLast().getMaster().isRightTrim()) {
            stringBuilder.append(this.getSymbols().getTrimChar());
        }
        stringBuilder.append(" ").append(this.getEndName()).append(" ");
        if (this.getMaster().isRightTrimAfterEnd()) {
            stringBuilder.append(this.getSymbols().getTrimChar());
        }
        stringBuilder.append(this.getSymbols().getExpressionEndWithTag());
        return stringBuilder.toString();
    }
}

