/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree;

import com.hubspot.jinjava.el.JinjavaProcessors;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.tree.output.OutputNode;
import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import java.io.Serializable;
import java.util.LinkedList;

public abstract class Node
implements Serializable {
    private final Token master;
    private final int lineNumber;
    private final int startPosition;
    private Node parent = null;
    private LinkedList<Node> children = new LinkedList();

    public Node(Token master, int lineNumber, int startPosition) {
        this.master = master;
        this.lineNumber = lineNumber;
        this.startPosition = startPosition;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Token getMaster() {
        return this.master;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public LinkedList<Node> getChildren() {
        return this.children;
    }

    public String reconstructImage() {
        return this.master.getImage();
    }

    public TokenScannerSymbols getSymbols() {
        return this.master.getSymbols();
    }

    public abstract OutputNode render(JinjavaInterpreter var1);

    public abstract String getName();

    public void preProcess(JinjavaInterpreter interpreter) {
        JinjavaProcessors processors = interpreter.getConfig().getProcessors();
        if (processors != null && processors.getNodePreProcessor() != null) {
            processors.getNodePreProcessor().accept(this, interpreter);
        }
    }

    public void postProcess(JinjavaInterpreter interpreter) {
        JinjavaProcessors processors = interpreter.getConfig().getProcessors();
        if (processors != null && processors.getNodePostProcessor() != null) {
            processors.getNodePostProcessor().accept(this, interpreter);
        }
    }
}

