/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.serialization;

import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.hubspot.jinjava.objects.PyWrapper;
import com.hubspot.jinjava.objects.serialization.PyishCharacterEscapes;
import com.hubspot.jinjava.objects.serialization.PyishPrettyPrinter;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public interface PyishSerializable
extends PyWrapper {
    public static final ObjectWriter SELF_WRITER = new ObjectMapper(new JsonFactoryBuilder().quoteChar('\'').build()).writer(PyishPrettyPrinter.INSTANCE).with(PyishCharacterEscapes.INSTANCE);

    default public <T extends Appendable & CharSequence> T appendPyishString(T appendable) throws IOException {
        return (T)appendable.append(PyishSerializable.writeValueAsString(this));
    }

    default public void writePyishSelf(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        AtomicInteger remainingLength = (AtomicInteger)serializerProvider.getAttribute("remainingLength");
        jsonGenerator.writeRawValue(((Serializable)this.appendPyishString(remainingLength == null ? new StringBuilder() : new LengthLimitingStringBuilder(remainingLength.get()))).toString());
    }

    public static String writeValueAsString(Object value) {
        try {
            return SELF_WRITER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            return '\'' + Objects.toString(value) + '\'';
        }
    }
}

