/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.date;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.objects.date.InvalidDateFormatException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class StrftimeFormatter {
    private static final Map<Character, ConversionComponent> COMPONENTS = ImmutableMap.builder().put(Character.valueOf('a'), ConversionComponent.pattern("EEE")).put(Character.valueOf('A'), ConversionComponent.pattern("EEEE")).put(Character.valueOf('b'), ConversionComponent.pattern("MMM")).put(Character.valueOf('B'), ConversionComponent.pattern("MMMM")).put(Character.valueOf('c'), ConversionComponent.localized(FormatStyle.MEDIUM, FormatStyle.MEDIUM)).put(Character.valueOf('d'), ConversionComponent.pattern("dd")).put(Character.valueOf('e'), ConversionComponent.pattern("d")).put(Character.valueOf('f'), ConversionComponent.pattern("SSSSSS")).put(Character.valueOf('H'), ConversionComponent.pattern("HH")).put(Character.valueOf('h'), ConversionComponent.pattern("hh")).put(Character.valueOf('I'), ConversionComponent.pattern("hh")).put(Character.valueOf('j'), ConversionComponent.pattern("DDD")).put(Character.valueOf('k'), ConversionComponent.pattern("H")).put(Character.valueOf('l'), ConversionComponent.pattern("h")).put(Character.valueOf('m'), ConversionComponent.pattern("MM")).put(Character.valueOf('M'), ConversionComponent.pattern("mm")).put(Character.valueOf('p'), ConversionComponent.pattern("a")).put(Character.valueOf('S'), ConversionComponent.pattern("ss")).put(Character.valueOf('U'), ConversionComponent.pattern("ww")).put(Character.valueOf('w'), ConversionComponent.pattern("e")).put(Character.valueOf('W'), ConversionComponent.pattern("ww")).put(Character.valueOf('x'), ConversionComponent.localized(FormatStyle.SHORT, null)).put(Character.valueOf('X'), ConversionComponent.localized(null, FormatStyle.MEDIUM)).put(Character.valueOf('y'), ConversionComponent.pattern("yy")).put(Character.valueOf('Y'), ConversionComponent.pattern("yyyy")).put(Character.valueOf('z'), ConversionComponent.pattern("Z")).put(Character.valueOf('Z'), ConversionComponent.pattern("z")).put(Character.valueOf('%'), (builder, stripLeadingZero) -> builder.appendLiteral("%")).build();
    private static final Map<Character, ConversionComponent> NOMINATIVE_COMPONENTS = ImmutableMap.builder().put(Character.valueOf('B'), ConversionComponent.pattern("LLLL")).build();

    public static DateTimeFormatter toDateTimeFormatter(String strftime) {
        if (!StringUtils.contains((CharSequence)strftime, 37)) {
            return DateTimeFormatter.ofPattern(strftime);
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        for (int i = 0; i < strftime.length(); ++i) {
            char c = strftime.charAt(i);
            if (c != '%' || strftime.length() <= i + 1) {
                builder.appendLiteral(c);
                continue;
            }
            c = strftime.charAt(++i);
            boolean stripLeadingZero = false;
            Map<Character, ConversionComponent> components = COMPONENTS;
            if (c == '-') {
                stripLeadingZero = true;
                c = strftime.charAt(++i);
            }
            if (c == 'O') {
                c = strftime.charAt(++i);
                components = NOMINATIVE_COMPONENTS;
            }
            char finalChar = c;
            Optional.ofNullable(components.get(Character.valueOf(finalChar))).orElseThrow(() -> new InvalidDateFormatException(strftime, String.format("unknown format code '%s'", Character.valueOf(finalChar)))).append(builder, stripLeadingZero);
        }
        return builder.toFormatter();
    }

    private static DateTimeFormatter formatter(String strftime, Locale locale) {
        DateTimeFormatter fmt;
        if (strftime == null) {
            strftime = "";
        }
        switch (strftime.toLowerCase()) {
            case "short": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
                break;
            }
            case "medium": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
                break;
            }
            case "long": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG);
                break;
            }
            case "full": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
                break;
            }
            default: {
                try {
                    fmt = StrftimeFormatter.toDateTimeFormatter(strftime);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidDateFormatException(strftime, e);
                }
            }
        }
        return fmt.withLocale(locale);
    }

    public static String format(ZonedDateTime d, Locale locale) {
        return StrftimeFormatter.format(d, "%H:%M / %d-%m-%Y", locale);
    }

    public static String format(ZonedDateTime d, String strftime) {
        return StrftimeFormatter.format(d, strftime, JinjavaInterpreter.getCurrentMaybe().map(JinjavaInterpreter::getConfig).map(JinjavaConfig::getLocale).orElse(Locale.ENGLISH));
    }

    public static String format(ZonedDateTime d, String strftime, Locale locale) {
        return StrftimeFormatter.formatter(strftime, locale).format(d);
    }

    static interface ConversionComponent {
        public DateTimeFormatterBuilder append(DateTimeFormatterBuilder var1, boolean var2);

        public static ConversionComponent pattern(String targetPattern) {
            return (builder, stripLeadingZero) -> builder.appendPattern(stripLeadingZero ? targetPattern.substring(1) : targetPattern);
        }

        public static ConversionComponent localized(FormatStyle dateStyle, FormatStyle timeStyle) {
            return (builder, stripLeadingZero) -> builder.appendLocalized(dateStyle, timeStyle);
        }
    }
}

