/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.date;

import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.objects.date.StrftimeFormatter;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import com.hubspot.jinjava.objects.serialization.PyishSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;

public final class PyishDate
extends Date
implements PyishSerializable,
Serializable {
    private final ZonedDateTime date;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";

    public PyishDate(ZonedDateTime dt) {
        super(dt.toInstant().toEpochMilli());
        this.date = dt;
    }

    public PyishDate(Instant instant) {
        this(ZonedDateTime.ofInstant(instant, ZoneOffset.UTC));
    }

    public String strftime(String fmt) {
        return StrftimeFormatter.format(this.date, fmt);
    }

    @Override
    public int getYear() {
        return this.date.getYear();
    }

    @Override
    public int getMonth() {
        return this.date.getMonthValue();
    }

    @Override
    public int getDay() {
        return this.date.getDayOfMonth();
    }

    public ZonedDateTime toDateTime() {
        return this.date;
    }

    @Override
    public String toString() {
        if (JinjavaInterpreter.getCurrent() != null && JinjavaInterpreter.getCurrent().getContext().containsKey("Jinjava_PyishDate_Custom_Format_Key")) {
            return this.strftime(JinjavaInterpreter.getCurrent().getContext().get("Jinjava_PyishDate_Custom_Format_Key").toString());
        }
        return this.strftime(this.dateFormat);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.date);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PyishDate that = (PyishDate)obj;
        return Objects.equals(this.toDateTime(), that.toDateTime());
    }

    @Override
    public <T extends Appendable & CharSequence> T appendPyishString(T appendable) throws IOException {
        return (T)appendable.append("('").append(this.strftime("yyyy-MM-dd'T'HH:mm:ss.SSSZ")).append("'|strtotime(").append(PyishObjectMapper.getAsPyishStringOrThrow("yyyy-MM-dd'T'HH:mm:ss.SSSZ")).append(")).withDateFormat(").append(PyishObjectMapper.getAsPyishStringOrThrow(this.dateFormat)).append(')');
    }
}

