/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.expression.EagerExpressionStrategy;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.CallTag;
import com.hubspot.jinjava.lib.tag.FlexibleTag;
import com.hubspot.jinjava.lib.tag.eager.DeferredToken;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.lib.tag.eager.EagerStateChangingTag;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.parse.ExpressionToken;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.EagerContextWatcher;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.LengthLimitingStringJoiner;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class EagerCallTag
extends EagerStateChangingTag<CallTag> {
    public EagerCallTag() {
        super(new CallTag());
    }

    public EagerCallTag(CallTag tag) {
        super(tag);
    }

    @Override
    public String eagerInterpret(TagNode tagNode, JinjavaInterpreter interpreter, InterpretException e) {
        PrefixToPreserveState prefixToPreserveState;
        EagerExecutionResult eagerExecutionResult;
        interpreter.getContext().checkNumberOfDeferredTokens();
        try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterNonStackingScope();){
            MacroFunction caller = new MacroFunction(tagNode.getChildren(), "caller", new LinkedHashMap<String, Object>(), true, interpreter.getContext(), interpreter.getLineNumber(), interpreter.getPosition());
            interpreter.getContext().addGlobalMacro(caller);
            eagerExecutionResult = EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.resolveExpression(tagNode.getHelpers().trim(), interpreter), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withTakeNewValue(true).withPartialMacroEvaluation(interpreter.getConfig().isNestedInterpretationEnabled()).build());
            prefixToPreserveState = new PrefixToPreserveState();
            if (!eagerExecutionResult.getResult().isFullyResolved() || interpreter.getContext().isDeferredExecutionMode()) {
                prefixToPreserveState.putAll(eagerExecutionResult.getPrefixToPreserveState());
            } else {
                EagerReconstructionUtils.commitSpeculativeBindings(interpreter, eagerExecutionResult);
            }
            if (eagerExecutionResult.getResult().isFullyResolved()) {
                String string = prefixToPreserveState.toString() + EagerExpressionStrategy.postProcessResult(new ExpressionToken(tagNode.getHelpers(), tagNode.getLineNumber(), tagNode.getStartPosition(), tagNode.getSymbols()), eagerExecutionResult.getResult().toString(true), interpreter);
                return string;
            }
            caller.setDeferred(true);
            EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, eagerExecutionResult.getResult().getDeferredWords(), interpreter);
        }
        prefixToPreserveState.withAllInFront(new EagerExecutionResult(eagerExecutionResult.getResult(), eagerExecutionResult.getSpeculativeBindings()).getPrefixToPreserveState());
        LengthLimitingStringJoiner joiner = new LengthLimitingStringJoiner(interpreter.getConfig().getMaxOutputSize(), " ");
        joiner.add(tagNode.getSymbols().getExpressionStartWithTag()).add(tagNode.getTag().getName()).add(eagerExecutionResult.getResult().toString().trim()).add(tagNode.getSymbols().getExpressionEndWithTag());
        prefixToPreserveState.withAllInFront(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromImage(joiner.toString(), tagNode.getMaster()).addUsedDeferredWords(eagerExecutionResult.getResult().getDeferredWords()).build()));
        StringBuilder result = new StringBuilder(prefixToPreserveState + joiner.toString());
        interpreter.getContext().setDynamicVariableResolver(s -> DeferredValue.instance());
        if (!tagNode.getChildren().isEmpty()) {
            result.append(EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.EagerExpressionResult.fromString(this.renderChildren(tagNode, (JinjavaInterpreter)eagerInterpreter)), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withForceDeferredExecutionMode(true).build()).asTemplateString());
        }
        if (StringUtils.isNotBlank(tagNode.getEndName()) && (!(this.getTag() instanceof FlexibleTag) || ((FlexibleTag)this.getTag()).hasEndTag((TagToken)tagNode.getMaster()))) {
            result.append(EagerReconstructionUtils.reconstructEnd(tagNode));
        }
        return EagerReconstructionUtils.wrapInAutoEscapeIfNeeded(result.toString(), interpreter);
    }
}

