/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.OutputTooBigException;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import com.hubspot.jinjava.util.ObjectTruthValue;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(params={@JinjavaParam(value="condition", type="conditional expression")})
public class IfTag
implements Tag {
    public static final String TAG_NAME = "if";
    private static final long serialVersionUID = -3784039314941268904L;

    @Override
    public boolean isRenderedInValidationMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        if (StringUtils.isBlank(tagNode.getHelpers())) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'if' expects expression", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        LengthLimitingStringBuilder sb = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
        Iterator nodeIterator = tagNode.getChildren().iterator();
        boolean parentValidationMode = interpreter.getContext().isValidationMode();
        boolean execute = this.isPositiveIfElseNode(tagNode, interpreter);
        boolean executedAnyBlock = false;
        try {
            while (nodeIterator.hasNext()) {
                Node node;
                boolean bl = executedAnyBlock = executedAnyBlock || execute;
                if (interpreter.isValidationMode() && !parentValidationMode) {
                    interpreter.getContext().setValidationMode(!execute);
                }
                if (TagNode.class.isAssignableFrom((node = (Node)nodeIterator.next()).getClass())) {
                    TagNode tag = (TagNode)node;
                    if (tag.getName().equals("elif")) {
                        execute = !executedAnyBlock && this.isPositiveIfElseNode(tag, interpreter);
                        continue;
                    }
                    if (tag.getName().equals("else")) {
                        execute = !executedAnyBlock;
                        continue;
                    }
                }
                if (execute) {
                    try {
                        sb.append(node.render(interpreter));
                        continue;
                    }
                    catch (OutputTooBigException e) {
                        interpreter.addError(TemplateError.fromOutputTooBigException(e));
                        String string = sb.toString();
                        interpreter.getContext().setValidationMode(parentValidationMode);
                        return string;
                    }
                }
                if (!interpreter.getContext().isValidationMode()) continue;
                node.render(interpreter);
            }
            return sb.toString();
        }
        finally {
            interpreter.getContext().setValidationMode(parentValidationMode);
        }
    }

    public boolean isPositiveIfElseNode(TagNode tagNode, JinjavaInterpreter interpreter) {
        return ObjectTruthValue.evaluate(interpreter.resolveELExpression(tagNode.getHelpers(), tagNode.getLineNumber(), tagNode.getStartPosition()));
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }
}

