/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import java.io.IOException;

@JinjavaDoc(params={@JinjavaParam(value="path")})
public class ExtendsTag
implements Tag {
    public static final String TAG_NAME = "extends";
    private static final long serialVersionUID = 4692863362280761393L;

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        if (interpreter.getContext().isDeferredExecutionMode()) {
            throw new DeferredValueException("extends tag");
        }
        HelperStringTokenizer tokenizer = new HelperStringTokenizer(tagNode.getHelpers());
        if (!tokenizer.hasNext()) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'extends' expects template path", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        String path = interpreter.resolveString((String)tokenizer.next(), tagNode.getLineNumber(), tagNode.getStartPosition());
        path = interpreter.resolveResourceLocation(path);
        interpreter.getContext().getExtendPathStack().push(path, tagNode.getLineNumber(), tagNode.getStartPosition());
        try {
            String template = interpreter.getResource(path);
            Node node = interpreter.parse(template);
            interpreter.getContext().addDependency("coded_files", path);
            interpreter.addExtendParentRoot(node);
            return "";
        }
        catch (IOException e) {
            throw new InterpretException(e.getMessage(), (Throwable)e, tagNode.getLineNumber(), tagNode.getStartPosition());
        }
    }

    @Override
    public String getEndTagName() {
        return null;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }
}

