/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.TagNode;
import java.util.LinkedHashMap;

@JinjavaDoc
public class CallTag
implements Tag {
    public static final String TAG_NAME = "call";
    private static final long serialVersionUID = 7231253469979314727L;

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        String macroExpr = "{{" + tagNode.getHelpers().trim() + "}}";
        try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();){
            LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
            MacroFunction caller = new MacroFunction(tagNode.getChildren(), "caller", args, true, interpreter.getContext(), interpreter.getLineNumber(), interpreter.getPosition());
            interpreter.getContext().addGlobalMacro(caller);
            String string = interpreter.render(macroExpr);
            return string;
        }
    }
}

