/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.output.BlockInfo;
import com.hubspot.jinjava.tree.output.BlockPlaceholderOutputNode;
import com.hubspot.jinjava.tree.output.OutputNode;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import com.hubspot.jinjava.util.WhitespaceUtils;

@JinjavaDoc(params={@JinjavaParam(value="block_name")})
public class BlockTag
implements Tag {
    public static final String TAG_NAME = "block";
    private static final long serialVersionUID = -2362317415797088108L;

    @Override
    public OutputNode interpretOutput(TagNode tagNode, JinjavaInterpreter interpreter) {
        HelperStringTokenizer tagData = new HelperStringTokenizer(tagNode.getHelpers());
        if (!tagData.hasNext()) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'block' expects an identifier", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        String blockName = WhitespaceUtils.unquote((String)tagData.next());
        interpreter.addBlock(blockName, new BlockInfo(tagNode.getChildren(), interpreter.getContext().getCurrentPathStack().peek(), interpreter.getContext().getCurrentPathStack().getTopLineNumber(), interpreter.getContext().getCurrentPathStack().getTopStartPosition()));
        return new BlockPlaceholderOutputNode(blockName);
    }

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        throw new UnsupportedOperationException("BlockTag must be rendered directly via interpretOutput() method");
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }
}

