/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(params={@JinjavaParam(value="autospace", type="boolean", defaultValue="True")})
public class XmlAttrFilter
implements Filter {
    @Override
    public String getName() {
        return "xmlattr";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (var == null || !Map.class.isAssignableFrom(var.getClass())) {
            return var;
        }
        Map dict = (Map)var;
        ArrayList<String> attrs = new ArrayList<String>();
        for (Map.Entry entry : dict.entrySet()) {
            attrs.add((String)entry.getKey() + "=\"" + StringEscapeUtils.escapeXml10(Objects.toString(entry.getValue(), "")) + "\"");
        }
        String space = " ";
        if (args.length > 0 && !BooleanUtils.toBoolean(args[0])) {
            space = "";
        }
        return space + StringUtils.join(attrs, "\n");
    }
}

