/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.WordUtils;

@JinjavaDoc(params={@JinjavaParam(value="width", type="number", defaultValue="79"), @JinjavaParam(value="break_long_words", type="boolean", defaultValue="True")})
public class WordWrapFilter
implements Filter {
    @Override
    public String getName() {
        return "wordwrap";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        String str = Objects.toString(var, "");
        int wrapLength = 79;
        if (args.length > 0) {
            wrapLength = NumberUtils.toInt(args[0], 79);
        }
        boolean wrapLongWords = true;
        if (args.length > 1) {
            wrapLongWords = BooleanUtils.toBoolean(args[1]);
        }
        return WordUtils.wrap(str, wrapLength, "\n", wrapLongWords);
    }
}

