/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc
public class UrlDecodeFilter
implements Filter {
    @Override
    public String getName() {
        return "urldecode";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (var == null && args.length == 0) {
            return "";
        }
        if (var != null) {
            if (Map.class.isAssignableFrom(var.getClass())) {
                Map dict = (Map)var;
                ArrayList<String> paramPairs = new ArrayList<String>();
                for (Map.Entry param : dict.entrySet()) {
                    StringBuilder paramPair = new StringBuilder();
                    paramPair.append(this.urlDecode(Objects.toString(param.getKey())));
                    paramPair.append("=");
                    paramPair.append(this.urlDecode(Objects.toString(param.getValue())));
                    paramPairs.add(paramPair.toString());
                }
                return StringUtils.join(paramPairs, "&");
            }
            return this.urlDecode(var.toString());
        }
        return this.urlDecode(args[0]);
    }

    private String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

