/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.util.ForLoop;
import com.hubspot.jinjava.util.ObjectIterator;
import java.util.LinkedHashMap;

@JinjavaDoc(params={@JinjavaParam(value="attr", type="Optional attribute on object to use as unique identifier")})
public class UniqueFilter
implements Filter {
    @Override
    public String getName() {
        return "unique";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        String attr = null;
        if (args.length > 0) {
            attr = args[0];
        }
        ForLoop loop = ObjectIterator.getLoop(var);
        while (loop.hasNext()) {
            Object val;
            Object key = val = loop.next();
            if (attr != null) {
                key = interpreter.resolveProperty(val, attr);
            }
            if (result.containsKey(key)) continue;
            result.put(key, val);
        }
        return result.values();
    }
}

