/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.regex.Pattern;
import jinjava.org.jsoup.Jsoup;
import jinjava.org.jsoup.safety.Safelist;

@JinjavaDoc
public class StripTagsFilter
implements Filter {
    private static final Pattern WHITESPACE = Pattern.compile("\\s{2,}");

    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        if (!(object instanceof String)) {
            return object;
        }
        int numDeferredTokensStart = interpreter.getContext().getDeferredTokens().size();
        try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();){
            String normalizedVal;
            String val = interpreter.renderFlat((String)object);
            if (interpreter.getContext().getDeferredTokens().size() > numDeferredTokensStart) {
                throw new DeferredValueException("Deferred in StripTagsFilter");
            }
            String cleanedVal = Jsoup.parse(val).text();
            cleanedVal = Jsoup.clean(cleanedVal, Safelist.none());
            cleanedVal = cleanedVal.replaceAll("&nbsp;", "\u00a0");
            String string = normalizedVal = WHITESPACE.matcher(cleanedVal).replaceAll(" ");
            return string;
        }
    }

    @Override
    public String getName() {
        return "striptags";
    }
}

