/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.util.ForLoop;
import com.hubspot.jinjava.util.ObjectIterator;
import java.util.ArrayList;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(params={@JinjavaParam(value="slices", type="number", required=true), @JinjavaParam(value="fillWith", type="object", required=false)})
public class SliceFilter
implements Filter {
    @Override
    public String getName() {
        return "slice";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        ForLoop loop = ObjectIterator.getLoop(var);
        if (args.length < 1) {
            throw new TemplateSyntaxException(interpreter, this.getName(), "requires 1 argument (number of slices)");
        }
        int slices = NumberUtils.toInt(args[0], 3);
        if (slices <= 0) {
            throw new InvalidArgumentException(interpreter, (Importable)this, InvalidReason.POSITIVE_NUMBER, 0, args[0]);
        }
        ArrayList result = new ArrayList();
        ArrayList<String> currentList = null;
        int i = 0;
        while (loop.hasNext()) {
            Object next = loop.next();
            if (i % slices == 0) {
                currentList = new ArrayList<String>(slices);
                result.add(currentList);
            }
            currentList.add((String)next);
            ++i;
        }
        if (args.length > 1 && currentList != null) {
            String fillWith = args[1];
            while (currentList.size() < slices) {
                currentList.add(fillWith);
            }
        }
        return result;
    }
}

