/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@JinjavaDoc
public class RandomFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            Collection clt = (Collection)object;
            int size = clt.size();
            if (size == 0) {
                return null;
            }
            Iterator it = clt.iterator();
            int index = interpreter.getRandom().nextInt(size);
            while (index-- > 0) {
                it.next();
            }
            return it.next();
        }
        if (object.getClass().isArray()) {
            int size = Array.getLength(object);
            if (size == 0) {
                return null;
            }
            int index = interpreter.getRandom().nextInt(size);
            return Array.get(object, index);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            int size = map.size();
            if (size == 0) {
                return null;
            }
            Iterator it = map.values().iterator();
            int index = interpreter.getRandom().nextInt(size);
            while (index-- > 0) {
                it.next();
            }
            return it.next();
        }
        if (object instanceof Number) {
            return interpreter.getRandom().nextInt(((Number)object).intValue());
        }
        if (object instanceof String) {
            try {
                return interpreter.getRandom().nextInt(new BigDecimal((String)object).intValue());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return object;
    }

    @Override
    public String getName() {
        return "random";
    }
}

