/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.AdvancedFilter;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.Objects;

@JinjavaDoc(params={@JinjavaParam(value="args", type="String...")})
public class FormatFilter
implements AdvancedFilter {
    public static final String NAME = "format";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, Object[] args, Map<String, Object> kwargs) {
        try {
            return String.format(Objects.toString(var, ""), args);
        }
        catch (IllegalFormatException e) {
            if (e instanceof MissingFormatArgumentException) {
                throw new InvalidArgumentException(interpreter, NAME, "Missing format argument for '" + ((MissingFormatArgumentException)e).getFormatSpecifier() + "'");
            }
            if (e instanceof IllegalFormatConversionException) {
                throw new InvalidArgumentException(interpreter, NAME, "'" + args[0] + "' is not a compatible type for conversion to format specifier '" + ((IllegalFormatConversionException)e).getConversion() + "'");
            }
            if (e instanceof MissingFormatWidthException) {
                throw new InvalidArgumentException(interpreter, NAME, "'" + ((MissingFormatWidthException)e).getFormatSpecifier() + "' is missing a width");
            }
            throw new InvalidArgumentException(interpreter, NAME, e.getMessage());
        }
    }
}

