/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import java.util.Locale;
import java.util.Objects;

@JinjavaDoc
public class EscapeJsFilter
implements Filter {
    @Override
    public Object filter(Object objectToFilter, JinjavaInterpreter jinjavaInterpreter, String ... strings) {
        String input = Objects.toString(objectToFilter, "");
        LengthLimitingStringBuilder builder = new LengthLimitingStringBuilder(jinjavaInterpreter.getConfig().getMaxOutputSize());
        block11: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch > '\u0fff') {
                builder.append("\\u");
                builder.append(this.toHex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                builder.append("\\u0");
                builder.append(this.toHex(ch));
                continue;
            }
            if (ch > '\u007f') {
                builder.append("\\u00");
                builder.append(this.toHex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        builder.append("\\b");
                        break;
                    }
                    case '\f': {
                        builder.append("\\f");
                        break;
                    }
                    case '\n': {
                        builder.append("\\n");
                        break;
                    }
                    case '\t': {
                        builder.append("\\t");
                        break;
                    }
                    case '\r': {
                        builder.append("\\r");
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            builder.append("\\u00");
                            builder.append(this.toHex(ch));
                            break;
                        }
                        builder.append("\\u000");
                        builder.append(this.toHex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\"': {
                    builder.append("\\\"");
                    continue block11;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block11;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return builder.toString();
    }

    @Override
    public String getName() {
        return "escapejs";
    }

    private String toHex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }
}

