/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.math.BigDecimal;
import java.math.BigInteger;

@JinjavaDoc
public class AbsFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return Math.abs((Integer)object);
        }
        if (object instanceof Float) {
            return Float.valueOf(Math.abs(((Float)object).floatValue()));
        }
        if (object instanceof Long) {
            return Math.abs((Long)object);
        }
        if (object instanceof Short) {
            return Math.abs(((Short)object).shortValue());
        }
        if (object instanceof Double) {
            return Math.abs((Double)object);
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).abs();
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).abs();
        }
        if (object instanceof Byte) {
            return Math.abs(((Byte)object).byteValue());
        }
        try {
            return new BigDecimal(object.toString()).abs();
        }
        catch (Exception e) {
            throw new InvalidInputException(interpreter, this, InvalidReason.NUMBER_FORMAT, object.toString());
        }
    }

    @Override
    public String getName() {
        return "abs";
    }
}

