/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Iterables;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.objects.collections.SizeLimitingPyList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jinjava.de.odysseus.el.misc.LocalMessages;
import jinjava.de.odysseus.el.tree.Bindings;
import jinjava.de.odysseus.el.tree.impl.ast.AstBracket;
import jinjava.de.odysseus.el.tree.impl.ast.AstNode;
import jinjava.javax.el.ELContext;
import jinjava.javax.el.ELException;
import jinjava.javax.el.PropertyNotFoundException;

public class AstRangeBracket
extends AstBracket {
    protected final AstNode rangeMax;

    public AstRangeBracket(AstNode base, AstNode rangeStart, AstNode rangeMax, boolean lvalue, boolean strict, boolean ignoreReturnType) {
        super(base, rangeStart, lvalue, strict, ignoreReturnType);
        this.rangeMax = rangeMax;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Integer end;
        Integer start;
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        boolean baseIsString = base.getClass().equals(String.class);
        if (!(Iterable.class.isAssignableFrom(base.getClass()) || base.getClass().isArray() || baseIsString)) {
            throw new ELException("Property " + this.prefix + " is not a sequence.");
        }
        if (baseIsString) {
            return this.evalString((String)base, bindings, context);
        }
        List<Object> baseItr = base.getClass().isArray() ? Arrays.asList((Object[])base) : (List<Object>)base;
        Integer n = start = this.property == null ? Integer.valueOf(0) : this.property.eval(bindings, context);
        if (start == null && this.strict) {
            return Collections.emptyList();
        }
        if (!(start instanceof Number)) {
            throw new ELException("Range start is not a number");
        }
        Integer n2 = end = this.rangeMax == null ? Integer.valueOf(Iterables.size(baseItr)) : this.rangeMax.eval(bindings, context);
        if (end == null && this.strict) {
            return Collections.emptyList();
        }
        if (!(end instanceof Number)) {
            throw new ELException("Range end is not a number");
        }
        int startNum = ((Number)start).intValue();
        int endNum = ((Number)end).intValue();
        JinjavaInterpreter interpreter = (JinjavaInterpreter)context.getELResolver().getValue(context, null, "____int3rpr3t3r____");
        SizeLimitingPyList result = new SizeLimitingPyList(new ArrayList<Object>(), interpreter.getConfig().getMaxListSize());
        int index = 0;
        if (startNum < 0 || endNum < 0) {
            int size;
            int n3 = size = this.rangeMax == null ? endNum : Iterables.size(baseItr);
            if (startNum < 0) {
                startNum += size;
            }
            if (endNum < 0) {
                endNum += size;
            }
        }
        for (Object t : baseItr) {
            if (index >= startNum) {
                if (index >= endNum) break;
                ((ForwardingCollection)result).add(t);
            }
            ++index;
        }
        return result;
    }

    private String evalString(String base, Bindings bindings, ELContext context) {
        if (base.length() == 0) {
            return base;
        }
        int startNum = this.intVal(this.property, 0, base.length(), bindings, context);
        int endNum = this.intVal(this.rangeMax, base.length(), base.length(), bindings, context);
        if (startNum > (endNum = Math.min(endNum, base.length()))) {
            return "";
        }
        return base.substring(startNum, endNum);
    }

    private int intVal(AstNode node, int defVal, int baseLength, Bindings bindings, ELContext context) {
        if (node == null) {
            return defVal;
        }
        Object val = node.eval(bindings, context);
        if (val == null) {
            return defVal;
        }
        if (!(val instanceof Number)) {
            throw new ELException("Range start/end is not a number");
        }
        int result = ((Number)val).intValue();
        return result >= 0 ? result : baseLength + result;
    }

    @Override
    public String toString() {
        return "[:]";
    }
}

