/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateStateException;
import com.hubspot.jinjava.objects.collections.SizeLimitingPyMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import jinjava.de.odysseus.el.tree.Bindings;
import jinjava.de.odysseus.el.tree.impl.ast.AstIdentifier;
import jinjava.de.odysseus.el.tree.impl.ast.AstLiteral;
import jinjava.de.odysseus.el.tree.impl.ast.AstNode;
import jinjava.de.odysseus.el.tree.impl.ast.AstString;
import jinjava.javax.el.ELContext;

public class AstDict
extends AstLiteral {
    protected final Map<AstNode, AstNode> dict;

    public AstDict(Map<AstNode, AstNode> dict) {
        this.dict = dict;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        LinkedHashMap<String, Object> resolved = new LinkedHashMap<String, Object>();
        JinjavaInterpreter interpreter = (JinjavaInterpreter)context.getELResolver().getValue(context, null, "____int3rpr3t3r____");
        for (Map.Entry<AstNode, AstNode> entry : this.dict.entrySet()) {
            String key;
            AstNode entryKey = entry.getKey();
            if (entryKey instanceof AstString) {
                key = Objects.toString(entryKey.eval(bindings, context));
            } else if (entryKey instanceof AstIdentifier) {
                Object result;
                key = interpreter.getConfig().getLegacyOverrides().isEvaluateMapKeys() ? ((result = entryKey.eval(bindings, context)) == null ? ((AstIdentifier)entryKey).getName() : result.toString()) : ((AstIdentifier)entryKey).getName();
            } else {
                throw new TemplateStateException("Dict key must be a string or identifier, was: " + entryKey);
            }
            resolved.put(key, entry.getValue().eval(bindings, context));
        }
        return new SizeLimitingPyMap(resolved, interpreter.getConfig().getMaxMapSize());
    }

    @Override
    public void appendStructure(StringBuilder builder, Bindings bindings) {
        throw new UnsupportedOperationException("appendStructure not implemented in " + this.getClass().getSimpleName());
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (Map.Entry<AstNode, AstNode> entry : this.dict.entrySet()) {
            s.append(entry.getKey()).append(":").append(entry.getValue());
        }
        return s.append("}").toString();
    }
}

