/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.google.common.collect.ImmutableSet;
import com.hubspot.jinjava.LegacyOverrides;
import com.hubspot.jinjava.el.JinjavaInterpreterResolver;
import com.hubspot.jinjava.el.JinjavaObjectUnwrapper;
import com.hubspot.jinjava.el.JinjavaProcessors;
import com.hubspot.jinjava.el.ObjectUnwrapper;
import com.hubspot.jinjava.features.FeatureConfig;
import com.hubspot.jinjava.features.Features;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.InterpreterFactory;
import com.hubspot.jinjava.interpret.JinjavaInterpreterFactory;
import com.hubspot.jinjava.mode.DefaultExecutionMode;
import com.hubspot.jinjava.mode.ExecutionMode;
import com.hubspot.jinjava.objects.date.CurrentDateTimeProvider;
import com.hubspot.jinjava.objects.date.DateTimeProvider;
import com.hubspot.jinjava.random.RandomNumberGeneratorStrategy;
import com.hubspot.jinjava.tree.parse.DefaultTokenScannerSymbols;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jinjava.javax.el.ELResolver;

public class JinjavaConfig {
    private final Charset charset;
    private final Locale locale;
    private final ZoneId timeZone;
    private final int maxRenderDepth;
    private final long maxOutputSize;
    private final boolean trimBlocks;
    private final boolean lstripBlocks;
    private final boolean enableRecursiveMacroCalls;
    private final int maxMacroRecursionDepth;
    private final Map<Context.Library, Set<String>> disabled;
    private final Set<String> restrictedMethods;
    private final Set<String> restrictedProperties;
    private final boolean failOnUnknownTokens;
    private final boolean nestedInterpretationEnabled;
    private final RandomNumberGeneratorStrategy randomNumberGenerator;
    private final boolean validationMode;
    private final long maxStringLength;
    private final int maxListSize;
    private final int maxMapSize;
    private final int rangeLimit;
    private final int maxNumDeferredTokens;
    private final InterpreterFactory interpreterFactory;
    private final DateTimeProvider dateTimeProvider;
    private TokenScannerSymbols tokenScannerSymbols;
    private final ELResolver elResolver;
    private final ExecutionMode executionMode;
    private final LegacyOverrides legacyOverrides;
    private final boolean enablePreciseDivideFilter;
    private final ObjectMapper objectMapper;
    private final Features features;
    private final ObjectUnwrapper objectUnwrapper;
    private final JinjavaProcessors processors;

    public static Builder newBuilder() {
        return new Builder();
    }

    public JinjavaConfig() {
        this(JinjavaConfig.newBuilder());
    }

    private JinjavaConfig(Builder builder) {
        this.charset = builder.charset;
        this.locale = builder.locale;
        this.timeZone = builder.timeZone;
        this.maxRenderDepth = builder.maxRenderDepth;
        this.disabled = builder.disabled;
        this.restrictedMethods = builder.restrictedMethods;
        this.restrictedProperties = builder.restrictedProperties;
        this.trimBlocks = builder.trimBlocks;
        this.lstripBlocks = builder.lstripBlocks;
        this.enableRecursiveMacroCalls = builder.enableRecursiveMacroCalls;
        this.maxMacroRecursionDepth = builder.maxMacroRecursionDepth;
        this.failOnUnknownTokens = builder.failOnUnknownTokens;
        this.maxOutputSize = builder.maxOutputSize;
        this.nestedInterpretationEnabled = builder.nestedInterpretationEnabled;
        this.randomNumberGenerator = builder.randomNumberGeneratorStrategy;
        this.validationMode = builder.validationMode;
        this.maxStringLength = builder.maxStringLength;
        this.maxListSize = builder.maxListSize;
        this.maxMapSize = builder.maxMapSize;
        this.rangeLimit = builder.rangeLimit;
        this.maxNumDeferredTokens = builder.maxNumDeferredTokens;
        this.interpreterFactory = builder.interpreterFactory;
        this.tokenScannerSymbols = builder.tokenScannerSymbols;
        this.elResolver = builder.elResolver;
        this.executionMode = builder.executionMode;
        this.legacyOverrides = builder.legacyOverrides;
        this.dateTimeProvider = builder.dateTimeProvider;
        this.enablePreciseDivideFilter = builder.enablePreciseDivideFilter;
        this.objectMapper = this.setupObjectMapper(builder.objectMapper);
        this.objectUnwrapper = builder.objectUnwrapper;
        this.processors = builder.processors;
        this.features = new Features(builder.featureConfig);
    }

    private ObjectMapper setupObjectMapper(ObjectMapper objectMapper) {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            if (this.legacyOverrides.isUseSnakeCasePropertyNaming()) {
                objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
            }
        }
        return objectMapper;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public int getMaxRenderDepth() {
        return this.maxRenderDepth;
    }

    public long getMaxOutputSize() {
        return this.maxOutputSize;
    }

    public int getMaxListSize() {
        return this.maxListSize;
    }

    public int getMaxMapSize() {
        return this.maxMapSize;
    }

    public int getRangeLimit() {
        return this.rangeLimit;
    }

    public int getMaxNumDeferredTokens() {
        return this.maxNumDeferredTokens;
    }

    public RandomNumberGeneratorStrategy getRandomNumberGeneratorStrategy() {
        return this.randomNumberGenerator;
    }

    public boolean isTrimBlocks() {
        return this.trimBlocks;
    }

    public boolean isLstripBlocks() {
        return this.lstripBlocks;
    }

    public boolean isEnableRecursiveMacroCalls() {
        return this.enableRecursiveMacroCalls;
    }

    public int getMaxMacroRecursionDepth() {
        return this.maxMacroRecursionDepth;
    }

    public Map<Context.Library, Set<String>> getDisabled() {
        return this.disabled;
    }

    public Set<String> getRestrictedMethods() {
        return this.restrictedMethods;
    }

    public Set<String> getRestrictedProperties() {
        return this.restrictedProperties;
    }

    public boolean isFailOnUnknownTokens() {
        return this.failOnUnknownTokens;
    }

    public boolean isNestedInterpretationEnabled() {
        return this.nestedInterpretationEnabled;
    }

    public boolean isValidationMode() {
        return this.validationMode;
    }

    public long getMaxStringLength() {
        return this.maxStringLength == 0L ? this.getMaxOutputSize() : this.maxStringLength;
    }

    public InterpreterFactory getInterpreterFactory() {
        return this.interpreterFactory;
    }

    public TokenScannerSymbols getTokenScannerSymbols() {
        return this.tokenScannerSymbols;
    }

    public ELResolver getElResolver() {
        return this.elResolver;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ObjectUnwrapper getObjectUnwrapper() {
        return this.objectUnwrapper;
    }

    public JinjavaProcessors getProcessors() {
        return this.processors;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public LegacyOverrides getLegacyOverrides() {
        return this.legacyOverrides;
    }

    public boolean getEnablePreciseDivideFilter() {
        return this.enablePreciseDivideFilter;
    }

    public DateTimeProvider getDateTimeProvider() {
        return this.dateTimeProvider;
    }

    public Features getFeatures() {
        return this.features;
    }

    public static class Builder {
        private Charset charset = StandardCharsets.UTF_8;
        private Locale locale = Locale.ENGLISH;
        private ZoneId timeZone = ZoneOffset.UTC;
        private int maxRenderDepth = 10;
        private long maxOutputSize = 0L;
        private Map<Context.Library, Set<String>> disabled = new HashMap<Context.Library, Set<String>>();
        private Set<String> restrictedMethods = ImmutableSet.of();
        private Set<String> restrictedProperties = ImmutableSet.of();
        private boolean trimBlocks;
        private boolean lstripBlocks;
        private boolean enableRecursiveMacroCalls;
        private int maxMacroRecursionDepth;
        private boolean failOnUnknownTokens;
        private boolean nestedInterpretationEnabled = true;
        private RandomNumberGeneratorStrategy randomNumberGeneratorStrategy = RandomNumberGeneratorStrategy.THREAD_LOCAL;
        private DateTimeProvider dateTimeProvider = new CurrentDateTimeProvider();
        private boolean validationMode = false;
        private long maxStringLength = 0L;
        private int rangeLimit = 1000;
        private int maxNumDeferredTokens = 1000;
        private InterpreterFactory interpreterFactory = new JinjavaInterpreterFactory();
        private TokenScannerSymbols tokenScannerSymbols = new DefaultTokenScannerSymbols();
        private ELResolver elResolver = JinjavaInterpreterResolver.DEFAULT_RESOLVER_READ_ONLY;
        private int maxListSize = Integer.MAX_VALUE;
        private int maxMapSize = Integer.MAX_VALUE;
        private ExecutionMode executionMode = DefaultExecutionMode.instance();
        private LegacyOverrides legacyOverrides = LegacyOverrides.NONE;
        private boolean enablePreciseDivideFilter = false;
        private ObjectMapper objectMapper = null;
        private ObjectUnwrapper objectUnwrapper = new JinjavaObjectUnwrapper();
        private JinjavaProcessors processors = JinjavaProcessors.newBuilder().build();
        private FeatureConfig featureConfig = FeatureConfig.newBuilder().build();

        private Builder() {
        }

        public Builder withTrimBlocks(boolean trimBlocks) {
            this.trimBlocks = trimBlocks;
            return this;
        }

        public Builder withLstripBlocks(boolean lstripBlocks) {
            this.lstripBlocks = lstripBlocks;
            return this;
        }

        public Builder withLegacyOverrides(LegacyOverrides legacyOverrides) {
            this.legacyOverrides = legacyOverrides;
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public JinjavaConfig build() {
            return new JinjavaConfig(this);
        }
    }
}

