/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ipv6;

import com.googlecode.ipv6.IPv6Address;
import java.io.Serializable;

public final class IPv6NetworkMask
implements Serializable {
    private final int prefixLength;

    IPv6NetworkMask(int prefixLength) {
        if (prefixLength < 0 || prefixLength > 128) {
            throw new IllegalArgumentException("prefix length should be in interval [0, 128]");
        }
        this.prefixLength = prefixLength;
    }

    public int asPrefixLength() {
        return this.prefixLength;
    }

    public IPv6Address asAddress() {
        if (this.prefixLength == 128) {
            return new IPv6Address(-1L, -1L);
        }
        if (this.prefixLength == 64) {
            return new IPv6Address(-1L, 0L);
        }
        if (this.prefixLength > 64) {
            int remainingPrefixLength = this.prefixLength - 64;
            return new IPv6Address(-1L, -1L << 64 - remainingPrefixLength);
        }
        if (this.prefixLength == 0) {
            return new IPv6Address(0L, 0L);
        }
        return new IPv6Address(-1L << 64 - this.prefixLength, 0L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPv6NetworkMask that = (IPv6NetworkMask)o;
        return this.prefixLength == that.prefixLength;
    }

    public int hashCode() {
        return this.prefixLength;
    }

    public String toString() {
        return "" + this.prefixLength;
    }
}

