/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ipv6;

import com.googlecode.ipv6.IPv6Address;
import com.googlecode.ipv6.IPv6AddressRange;
import com.googlecode.ipv6.IPv6NetworkMask;

public final class IPv6Network
extends IPv6AddressRange {
    public static final IPv6Network MULTICAST_NETWORK = IPv6Network.fromString("ff00::/8");
    public static final IPv6Network SITE_LOCAL_NETWORK = IPv6Network.fromString("fec0::/48");
    public static final IPv6Network LINK_LOCAL_NETWORK = IPv6Network.fromString("fe80::/64");
    private final IPv6Address address;
    private final IPv6NetworkMask networkMask;

    private IPv6Network(IPv6Address address, IPv6NetworkMask networkMask) {
        super(address.maskWithNetworkMask(networkMask), address.maximumAddressWithNetworkMask(networkMask));
        this.address = address.maskWithNetworkMask(networkMask);
        this.networkMask = networkMask;
    }

    public static IPv6Network fromAddressAndMask(IPv6Address address, IPv6NetworkMask networkMask) {
        return new IPv6Network(address, networkMask);
    }

    public static IPv6Network fromString(String string) {
        if (string.indexOf(47) == -1) {
            throw new IllegalArgumentException("Expected format is network-address/prefix-length");
        }
        String networkAddressString = IPv6Network.parseNetworkAddress(string);
        int prefixLength = IPv6Network.parsePrefixLength(string);
        IPv6Address networkAddress = IPv6Address.fromString(networkAddressString);
        return IPv6Network.fromAddressAndMask(networkAddress, new IPv6NetworkMask(prefixLength));
    }

    private static String parseNetworkAddress(String string) {
        return string.substring(0, string.indexOf(47));
    }

    private static int parsePrefixLength(String string) {
        try {
            return Integer.parseInt(string.substring(string.indexOf(47) + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Prefix length should be a positive integer");
        }
    }

    @Override
    public String toString() {
        return this.address.toString() + "/" + this.networkMask.asPrefixLength();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPv6Network that = (IPv6Network)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        return !(this.networkMask != null ? !this.networkMask.equals(that.networkMask) : that.networkMask != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.networkMask != null ? this.networkMask.hashCode() : 0);
        return result;
    }

    public IPv6NetworkMask getNetmask() {
        return this.networkMask;
    }
}

