/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import com.google.re2j.Matcher;
import com.google.re2j.RE2;
import java.io.Serializable;

public final class Pattern
implements Serializable {
    private final String pattern;
    private final int flags;
    private final transient RE2 re2;

    Pattern(String pattern, int flags, RE2 re2) {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        if (re2 == null) {
            throw new NullPointerException("re2 is null");
        }
        this.pattern = pattern;
        this.flags = flags;
        this.re2 = re2;
    }

    RE2 re2() {
        return this.re2;
    }

    public static Pattern compile(String regex) {
        return Pattern.compile(regex, regex, 0);
    }

    private static Pattern compile(String flregex, String regex, int flags) {
        int re2Flags = 212;
        if ((flags & 8) != 0) {
            re2Flags &= 0xFFFFFF7F;
        }
        return new Pattern(regex, flags, RE2.compileImpl(flregex, re2Flags, false));
    }

    public Matcher matcher(CharSequence input) {
        return new Matcher(this, input);
    }

    public String toString() {
        return this.pattern;
    }
}

