/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.tensor;

import com.github.tjake.jlama.safetensors.DType;
import com.github.tjake.jlama.tensor.AbstractTensor;
import com.github.tjake.jlama.tensor.FloatBufferTensor;
import com.github.tjake.jlama.tensor.TensorShape;
import com.github.tjake.jlama.util.UnsafeDirectByteBuffer;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.VectorSpecies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Q4ByteBufferTensor
extends AbstractTensor<ByteVector, Byte> {
    private static final Logger logger = LoggerFactory.getLogger(Q4ByteBufferTensor.class);
    public static final int BLOCK_SIZE = 32;
    public static final int HALF_BLOCK = 16;
    private static final float I_BLOCK_SIZE = 0.03125f;
    final ByteBuffer b;
    final FloatBufferTensor blockF;
    private final String name;
    private final MemorySegment segment;

    public Q4ByteBufferTensor(AbstractTensor ft) {
        this(ft.shape);
        Preconditions.checkArgument(ft.dType != DType.Q4, "This should never happen, likely a bug");
        Preconditions.checkArgument(ft.size() % 32L == 0L, "I8 buffer must be a multiple of BLOCK_SIZE");
        ArrayList<int[]> startBlockCursors = new ArrayList<int[]>();
        int[] cursor = new int[ft.shape.dims()];
        int c = 0;
        do {
            if (c++ % 32 != 0) continue;
            startBlockCursors.add(Arrays.copyOf(cursor, cursor.length));
        } while (ft.iterate(cursor));
        IntStream.range(0, startBlockCursors.size()).parallel().forEach(i -> {
            int[] blockStartCursor = (int[])startBlockCursors.get(i);
            this.processBlock(ft, blockStartCursor);
        });
    }

    void processBlock(AbstractTensor ft, int[] blockStartCursor) {
        int[] cursor = Arrays.copyOf(blockStartCursor, blockStartCursor.length);
        float max = Float.MIN_VALUE;
        float amax = Float.MIN_VALUE;
        for (int i = 0; i < 32; ++i) {
            float absv;
            float v = ft.get(cursor);
            float f = absv = v < 0.0f ? -v : v;
            if (absv > amax) {
                max = v;
                amax = absv;
            }
            ft.iterate(cursor);
        }
        float scale = max / -8.0f;
        float iscale = scale != 0.0f ? 1.0f / scale : 0.0f;
        this.blockF.set(scale, Q4ByteBufferTensor.makeBlockShape(blockStartCursor));
        int i = ft.getOffset(blockStartCursor);
        int ibyte = i / 2;
        int j = 0;
        while (j < 16) {
            float f0 = ft.get(blockStartCursor) * iscale;
            int n = blockStartCursor.length - 1;
            blockStartCursor[n] = blockStartCursor[n] + 16;
            float f1 = ft.get(blockStartCursor) * iscale;
            int n2 = blockStartCursor.length - 1;
            blockStartCursor[n2] = blockStartCursor[n2] - 16;
            ft.iterate(blockStartCursor);
            byte fb0 = (byte)Math.min(15, (byte)(f0 + 8.5f));
            byte fb1 = (byte)Math.min(15, (byte)(f1 + 8.5f));
            this.b.put(ibyte, (byte)(fb0 | fb1 << 4));
            ++j;
            ++i;
            ++ibyte;
        }
    }

    static int[] makeBlockShape(int ... shape) {
        int[] blockShape = new int[shape.length];
        for (int i = 0; i < shape.length - 1; ++i) {
            blockShape[i] = shape[i];
        }
        blockShape[shape.length - 1] = (int)((float)shape[shape.length - 1] * 0.03125f);
        return blockShape;
    }

    static TensorShape makeBlockShape(TensorShape shape) {
        return shape.scaleLastDim(0.03125f);
    }

    protected Q4ByteBufferTensor(TensorShape shape) {
        super(DType.Q4, shape, true);
        Preconditions.checkArgument(this.size() % 32L == 0L, "Tensor must be a multiple of BLOCK_SIZE");
        this.blockF = new FloatBufferTensor(Q4ByteBufferTensor.makeBlockShape(shape));
        this.name = "tmp";
        this.b = UnsafeDirectByteBuffer.allocateAlignedByteBuffer(Ints.checkedCast(this.size() / 2L), 64L).order(ByteOrder.LITTLE_ENDIAN);
        this.segment = MemorySegment.ofBuffer(this.b);
    }

    public Q4ByteBufferTensor(String name, ByteBuffer b, FloatBufferTensor blockF, TensorShape shape, boolean cacheSlices) {
        super(DType.Q4, shape, cacheSlices);
        this.blockF = blockF;
        this.name = name;
        if (b.isDirect()) {
            this.b = b;
        } else {
            this.b = ByteBuffer.allocateDirect(b.remaining()).order(ByteOrder.LITTLE_ENDIAN);
            this.b.duplicate().put(b);
        }
        this.segment = MemorySegment.ofBuffer(this.b);
    }

    @Override
    protected AbstractTensor make(TensorShape shape) {
        return new Q4ByteBufferTensor(shape);
    }

    @Override
    protected AbstractTensor make(int offset, int length, TensorShape shape, boolean cacheSlices) {
        FloatBufferTensor newBlockF = (FloatBufferTensor)this.blockF.make((int)((float)offset * 0.03125f), (int)((float)length * 0.03125f), Q4ByteBufferTensor.makeBlockShape(shape), cacheSlices);
        return new Q4ByteBufferTensor(this.name, this.b.slice(offset / 2, length / 2), newBlockF, shape, cacheSlices);
    }

    @Override
    public float get(int ... dims) {
        int x;
        Preconditions.checkArgument(dims.length <= this.shape.dims(), "Too many dimensions specified");
        Preconditions.checkArgument(dims.length == this.shape.dims(), "Must specify all dimensions");
        int i = this.getOffset(dims);
        float scale = this.blockF.get(Q4ByteBufferTensor.makeBlockShape(dims));
        int ibyte = (int)((float)i * 0.03125f) * 16 + i % 32;
        if (i % 32 < 16) {
            byte b0 = this.b.get(ibyte);
            x = (b0 & 0xF) - 8;
        } else {
            byte b0 = this.b.get(ibyte - 16);
            x = (b0 >> 4 & 0xF) - 8;
        }
        return (float)x * scale;
    }

    public float getFactorForIndex(int d, int i) {
        int ix = (int)((float)i * 0.03125f);
        return this.blockF.get(d, ix);
    }

    public FloatBufferTensor getBlockF() {
        return this.blockF;
    }

    @Override
    public void set(float v, int ... dims) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteVector getVector(VectorSpecies<Byte> species, int ... voffset) {
        int offset = this.getOffset(voffset);
        return ByteVector.fromMemorySegment(species, (MemorySegment)this.segment, (long)this.getMemorySegmentOffset(offset), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void intoTensor(ByteVector vector, int ... aoffset) {
        Preconditions.checkArgument(!this.b.isReadOnly());
        int offset = this.getOffset(aoffset);
        vector.intoMemorySegment(this.segment, (long)this.getMemorySegmentOffset(offset), ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public MemorySegment getMemorySegment() {
        return this.segment;
    }

    @Override
    public int getMemorySegmentOffset(int offset) {
        return offset / 2;
    }

    @Override
    public void copyFrom(AbstractTensor src, int srcOffset, int destOffset, int length) {
        Preconditions.checkArgument(this.dType == src.dType, "different types");
        Preconditions.checkArgument(!this.b.isReadOnly(), "Read-only");
        this.segment.asSlice((long)this.getMemorySegmentOffset(destOffset), length / 2).copyFrom(src.getMemorySegment().asSlice((long)src.getMemorySegmentOffset(srcOffset), length / 2));
        Q4ByteBufferTensor srcQ4 = (Q4ByteBufferTensor)src;
        this.blockF.copyFrom(srcQ4.blockF, srcOffset / 32, destOffset / 32, length / 32);
    }

    @Override
    public void clear() {
        Preconditions.checkArgument(!this.b.isReadOnly(), "Can't clear a read-only buffer");
        this.segment.fill((byte)0);
    }

    public String toString() {
        byte[] sample = new byte[Math.min(32, this.b.remaining())];
        this.b.duplicate().get(sample);
        return "Q4BufferTensor{name='" + this.name + "'shape=" + String.valueOf(this.shape) + ", b=" + Arrays.toString(sample) + "...}";
    }
}

