/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.model.functions;

import com.github.tjake.jlama.safetensors.Config;
import com.github.tjake.jlama.safetensors.prompt.PromptContext;
import com.github.tjake.jlama.safetensors.prompt.PromptSupport;
import com.github.tjake.jlama.safetensors.prompt.ToolCall;
import com.github.tjake.jlama.safetensors.tokenizer.Tokenizer;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;

public interface Generator
extends Closeable {
    public Response generate(UUID var1, PromptContext var2, float var3, int var4, BiConsumer<String, Float> var5);

    default public Response generate(UUID session, PromptContext promptContext, float temperature, int ntokens) {
        return this.generate(session, promptContext, temperature, ntokens, (s, aFloat) -> {});
    }

    default public GenerateBuilder generateBuilder() {
        return new GenerateBuilder(this);
    }

    public float[] embed(String var1, PoolingType var2);

    default public Map<String, Float> classify(String input, PoolingType poolingType) {
        throw new UnsupportedOperationException("Classification not supported by this model");
    }

    public Config getConfig();

    public Tokenizer getTokenizer();

    public Optional<PromptSupport> promptSupport();

    public static class Response {
        public final String responseText;
        public final String responseTextWithSpecialTokens;
        public final FinishReason finishReason;
        public final int promptTokens;
        public final int generatedTokens;
        public final long promptTimeMs;
        public final long generateTimeMs;
        public final List<ToolCall> toolCalls;

        public Response(String responseText, String responseTextWithSpecialTokens, FinishReason finishReason, int promptTokens, int generatedTokens, long promptTimeMs, long generateTimeMs) {
            this.responseText = responseText;
            this.responseTextWithSpecialTokens = responseTextWithSpecialTokens;
            this.finishReason = finishReason;
            this.promptTokens = promptTokens;
            this.generatedTokens = generatedTokens;
            this.promptTimeMs = promptTimeMs;
            this.generateTimeMs = generateTimeMs;
            this.toolCalls = Collections.emptyList();
        }

        private Response(String responseText, String responseTextWithSpecialTokens, FinishReason finishReason, int promptTokens, int generatedTokens, long promptTimeMs, long generateTimeMs, List<ToolCall> toolCalls) {
            this.responseText = responseText;
            this.responseTextWithSpecialTokens = responseTextWithSpecialTokens;
            this.finishReason = finishReason;
            this.promptTokens = promptTokens;
            this.generatedTokens = generatedTokens;
            this.promptTimeMs = promptTimeMs;
            this.generateTimeMs = generateTimeMs;
            this.toolCalls = toolCalls;
        }

        public Response copyWithToolCalls(List<ToolCall> toolCalls) {
            return new Response(this.responseText, this.responseTextWithSpecialTokens, FinishReason.TOOL_CALL, this.promptTokens, this.generatedTokens, this.promptTimeMs, this.generateTimeMs, toolCalls);
        }

        public String toString() {
            return "Response{responseText='" + this.responseText + "', responseTextWithSpecialTokens='" + this.responseTextWithSpecialTokens + "', finishReason=" + String.valueOf((Object)this.finishReason) + ", promptTokens=" + this.promptTokens + ", generatedTokens=" + this.generatedTokens + ", promptTimeMs=" + this.promptTimeMs + ", generateTimeMs=" + this.generateTimeMs + "}";
        }
    }

    public static class GenerateBuilder {
        private UUID session = UUID.randomUUID();
        private PromptContext promptContext;
        private float temperature = 0.0f;
        private int ntokens = 256;
        private BiConsumer<String, Float> onTokenWithTimings = (s, aFloat) -> {};
        private final Generator generator;

        public GenerateBuilder(Generator generator) {
            this.generator = generator;
        }

        public GenerateBuilder session(UUID session) {
            this.session = session;
            return this;
        }

        public GenerateBuilder session(String session) {
            this.session = UUID.fromString(session);
            return this;
        }

        public GenerateBuilder promptContext(PromptContext promptContext) {
            this.promptContext = promptContext;
            return this;
        }

        public GenerateBuilder prompt(String prompt) {
            this.promptContext = PromptContext.of(prompt);
            return this;
        }

        public GenerateBuilder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        public GenerateBuilder ntokens(int ntokens) {
            this.ntokens = ntokens;
            return this;
        }

        public GenerateBuilder onTokenWithTimings(BiConsumer<String, Float> onTokenWithTimings) {
            this.onTokenWithTimings = onTokenWithTimings;
            return this;
        }

        public Response generate() {
            if (this.promptContext == null) {
                throw new IllegalArgumentException("promptContext cannot be null");
            }
            return this.generator.generate(this.session, this.promptContext, this.temperature, this.ntokens, this.onTokenWithTimings);
        }
    }

    public static enum PoolingType {
        MODEL,
        AVG,
        MAX,
        SUM;

    }

    public static enum FinishReason {
        MAX_TOKENS,
        STOP_TOKEN,
        TOOL_CALL,
        ERROR;

    }
}

