/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class ObjectNode
extends ContainerNode<ObjectNode>
implements Serializable {
    protected final Map<String, JsonNode> _children = new LinkedHashMap<String, JsonNode>();

    public ObjectNode(JsonNodeFactory nc) {
        super(nc);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public final boolean isObject() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(String propertyName) {
        return this._children.get(propertyName);
    }

    @Override
    public JsonNode path(String propertyName) {
        JsonNode n = this._children.get(propertyName);
        if (n != null) {
            return n;
        }
        return MissingNode.getInstance();
    }

    @Override
    @Deprecated
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public Set<Map.Entry<String, JsonNode>> properties() {
        return this._children.entrySet();
    }

    @Override
    public void serialize(JsonGenerator g, SerializerProvider ctxt) throws IOException {
        if (ctxt != null) {
            boolean skipNulls;
            boolean trimEmptyArray = !ctxt.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            boolean bl = skipNulls = !ctxt.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
            if (trimEmptyArray || skipNulls) {
                g.writeStartObject(this);
                this.serializeFilteredContents(g, ctxt, trimEmptyArray, skipNulls);
                g.writeEndObject();
                return;
            }
        }
        Map<String, JsonNode> contents = this._contentsToSerialize(ctxt);
        g.writeStartObject(this, contents.size());
        for (Map.Entry<String, JsonNode> en : contents.entrySet()) {
            g.writeFieldName(en.getKey());
            en.getValue().serialize(g, ctxt);
        }
        g.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        boolean trimEmptyArray = false;
        boolean skipNulls = false;
        if (provider != null) {
            trimEmptyArray = !provider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            skipNulls = !provider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
        }
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(this, JsonToken.START_OBJECT));
        if (trimEmptyArray || skipNulls) {
            this.serializeFilteredContents(g, provider, trimEmptyArray, skipNulls);
        } else {
            for (Map.Entry<String, JsonNode> en : this._contentsToSerialize(provider).entrySet()) {
                JsonNode value = en.getValue();
                g.writeFieldName(en.getKey());
                value.serialize(g, provider);
            }
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    protected void serializeFilteredContents(JsonGenerator g, SerializerProvider ctxt, boolean trimEmptyArray, boolean skipNulls) throws IOException {
        for (Map.Entry<String, JsonNode> en : this._contentsToSerialize(ctxt).entrySet()) {
            JsonNode value = en.getValue();
            if (trimEmptyArray && value.isArray() && value.isEmpty(ctxt) || skipNulls && value.isNull()) continue;
            g.writeFieldName(en.getKey());
            value.serialize(g, ctxt);
        }
    }

    protected Map<String, JsonNode> _contentsToSerialize(SerializerProvider ctxt) {
        if (ctxt.isEnabled(JsonNodeFeature.WRITE_PROPERTIES_SORTED) && !this._children.isEmpty() && !(this._children instanceof TreeMap)) {
            return new TreeMap<String, JsonNode>(this._children);
        }
        return this._children;
    }

    public <T extends JsonNode> T set(String propertyName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return (T)this._put(propertyName, value);
    }

    public JsonNode replace(String propertyName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._children.put(Objects.requireNonNull(propertyName), value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)o);
        }
        return false;
    }

    protected boolean _childrenEqual(ObjectNode other) {
        return this._children.equals(other._children);
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    protected ObjectNode _put(String propertyName, JsonNode value) {
        this._children.put(Objects.requireNonNull(propertyName), value);
        return this;
    }
}

