/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import java.io.Serializable;

public class DatatypeFeatures
implements Serializable {
    private final int _enabledFor1;
    private final int _enabledFor2;
    private final int _explicitFor1;
    private final int _explicitFor2;

    protected DatatypeFeatures(int enabledFor1, int explicitFor1, int enabledFor2, int explicitFor2) {
        this._enabledFor1 = enabledFor1;
        this._explicitFor1 = explicitFor1;
        this._enabledFor2 = enabledFor2;
        this._explicitFor2 = explicitFor2;
    }

    public static DatatypeFeatures defaultFeatures() {
        return DefaultHolder.getDefault();
    }

    public boolean isEnabled(DatatypeFeature f) {
        switch (f.featureIndex()) {
            case 0: {
                return f.enabledIn(this._enabledFor1);
            }
            case 1: {
                return f.enabledIn(this._enabledFor2);
            }
        }
        VersionUtil.throwInternal();
        return false;
    }

    public boolean isExplicitlySet(DatatypeFeature f) {
        switch (f.featureIndex()) {
            case 0: {
                return f.enabledIn(this._explicitFor1);
            }
            case 1: {
                return f.enabledIn(this._explicitFor2);
            }
        }
        VersionUtil.throwInternal();
        return false;
    }

    public Boolean getExplicitState(DatatypeFeature f) {
        switch (f.featureIndex()) {
            case 0: {
                if (f.enabledIn(this._explicitFor1)) {
                    return f.enabledIn(this._enabledFor1);
                }
                return null;
            }
            case 1: {
                if (f.enabledIn(this._explicitFor2)) {
                    return f.enabledIn(this._enabledFor2);
                }
                return null;
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    private static class DefaultHolder {
        private static final DatatypeFeatures DEFAULT_FEATURES = new DatatypeFeatures(DefaultHolder.collectDefaults((Enum[])EnumFeature.values()), 0, DefaultHolder.collectDefaults((Enum[])JsonNodeFeature.values()), 0);

        private static <F extends Enum<F>> int collectDefaults(F[] features) {
            int flags = 0;
            for (F f : features) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        public static DatatypeFeatures getDefault() {
            return DEFAULT_FEATURES;
        }
    }
}

