/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;

public class BigRational
implements Comparable<BigRational> {
    public static final BigRational ZERO = new BigRational(0);
    public static final BigRational ONE = new BigRational(1);
    public static final BigRational TWO = new BigRational(2);
    public static final BigRational TEN = new BigRational(10);
    private final BigDecimal numerator;
    private final BigDecimal denominator;
    private static List<BigRational> bernoulliCache = new ArrayList<BigRational>();

    private BigRational(int value) {
        this(BigDecimal.valueOf(value), BigDecimal.ONE);
    }

    private BigRational(BigDecimal num, BigDecimal denom) {
        BigDecimal n = num;
        BigDecimal d = denom;
        if (d.signum() == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (d.signum() < 0) {
            n = n.negate();
            d = d.negate();
        }
        this.numerator = n;
        this.denominator = d;
    }

    public BigDecimal getNumerator() {
        return this.numerator;
    }

    public BigDecimal getDenominator() {
        return this.denominator;
    }

    private BigRational divide(BigDecimal value) {
        BigDecimal n = this.numerator;
        BigDecimal d = this.denominator.multiply(value);
        return BigRational.of(n, d);
    }

    public BigRational divide(BigInteger value) {
        if (value.equals(BigInteger.ONE)) {
            return this;
        }
        return this.divide(new BigDecimal(value));
    }

    public BigRational divide(int value) {
        return this.divide(BigInteger.valueOf(value));
    }

    public boolean isZero() {
        return this.numerator.signum() == 0;
    }

    private boolean isIntegerInternal() {
        return this.denominator.compareTo(BigDecimal.ONE) == 0;
    }

    private static int countDigits(BigInteger number) {
        double factor = Math.log(2.0) / Math.log(10.0);
        int digitCount = (int)(factor * (double)number.bitLength() + 1.0);
        if (BigInteger.TEN.pow(digitCount - 1).compareTo(number) > 0) {
            return digitCount - 1;
        }
        return digitCount;
    }

    private int precision() {
        return BigRational.countDigits(this.numerator.toBigInteger()) + BigRational.countDigits(this.denominator.toBigInteger());
    }

    public BigDecimal toBigDecimal() {
        int precision = Math.max(this.precision(), MathContext.DECIMAL128.getPrecision());
        return this.toBigDecimal(new MathContext(precision));
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        return this.numerator.divide(this.denominator, mc);
    }

    @Override
    public int compareTo(BigRational other) {
        if (this == other) {
            return 0;
        }
        return this.numerator.multiply(other.denominator).compareTo(this.denominator.multiply(other.numerator));
    }

    public int hashCode() {
        if (this.isZero()) {
            return 0;
        }
        return this.numerator.hashCode() + this.denominator.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BigRational)) {
            return false;
        }
        BigRational other = (BigRational)obj;
        if (!this.numerator.equals(other.numerator)) {
            return false;
        }
        return this.denominator.equals(other.denominator);
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isIntegerInternal()) {
            return this.numerator.toString();
        }
        return this.toBigDecimal().toString();
    }

    private static BigRational of(BigDecimal numerator, BigDecimal denominator) {
        if (numerator.signum() == 0 && denominator.signum() != 0) {
            return ZERO;
        }
        if (numerator.compareTo(BigDecimal.ONE) == 0 && denominator.compareTo(BigDecimal.ONE) == 0) {
            return ONE;
        }
        return new BigRational(numerator, denominator);
    }
}

