/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.gjt.jclasslib.io.DataInput;
import org.gjt.jclasslib.io.DataOutput;
import org.gjt.jclasslib.structures.AccessFlag;
import org.gjt.jclasslib.structures.AttributeContainer;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.Constant;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.FieldInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.MethodInfo;
import org.gjt.jclasslib.structures.Package;
import org.gjt.jclasslib.structures.Structure;
import org.gjt.jclasslib.structures.constants.ConstantClassInfo;
import org.gjt.jclasslib.structures.constants.ConstantPlaceholder;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 \u0084\u00012\u00020\u00012\u00020\u0002:\u0004\u0083\u0001\u0084\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010G\u001a\u00020\u00062\u0006\u0010H\u001a\u00020\u0010J\u0019\u0010I\u001a\u00020J2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010L\u001a\u00020J2\u0006\u0010M\u001a\u00020\u0006J\u000e\u0010N\u001a\u00020J2\u0006\u0010M\u001a\u00020\u0006J\u000e\u0010Y\u001a\u00020Z2\u0006\u0010M\u001a\u00020\u0006J+\u0010[\u001a\u0002H\\\"\b\b\u0000\u0010\\*\u00020\u00102\u0006\u0010M\u001a\u00020\u00062\f\u0010]\u001a\b\u0012\u0004\u0012\u0002H\\0^\u00a2\u0006\u0002\u0010_J\u000e\u0010`\u001a\u00020D2\u0006\u0010M\u001a\u00020\u0006J\u0016\u0010a\u001a\u00020\u00062\u0006\u0010b\u001a\u00020D2\u0006\u0010c\u001a\u00020DJ\u0018\u0010d\u001a\u0004\u0018\u00010/2\u0006\u0010b\u001a\u00020D2\u0006\u0010c\u001a\u00020DJ\u0016\u0010e\u001a\u00020\u00062\u0006\u0010b\u001a\u00020D2\u0006\u0010c\u001a\u00020DJ\u0018\u0010f\u001a\u0004\u0018\u0001062\u0006\u0010b\u001a\u00020D2\u0006\u0010c\u001a\u00020DJ\u0010\u0010g\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0014J\u0010\u0010j\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0014J\u0010\u0010o\u001a\u00020J2\u0006\u0010M\u001a\u00020\u0006H\u0002J\u0010\u0010p\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010q\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010r\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010s\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010t\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010u\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010v\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010w\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010x\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010y\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010z\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010{\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010|\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010}\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010~\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010\u007f\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0002J\u0011\u0010\u0080\u0001\u001a\u00020J2\u0006\u0010h\u001a\u00020iH\u0002J\u0011\u0010\u0081\u0001\u001a\u00020J2\u0006\u0010k\u001a\u00020lH\u0002J\u0011\u0010\u0082\u0001\u001a\u00020J2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u0017j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0006`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\nR\u001a\u0010\u001c\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\b\"\u0004\b\u001e\u0010\nR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\b\"\u0004\b%\u0010\nR\u0011\u0010&\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\"R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\"\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00104\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\"\u00105\u001a\b\u0012\u0004\u0012\u0002060\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010;\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\"\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u000fX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010B\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u0011\u0010C\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0011\u0010O\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010FR\u0011\u0010Q\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010FR\u0011\u0010S\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010FR\u0011\u0010U\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010FR\u0011\u0010W\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bX\u0010FR\u0014\u0010m\u001a\u00020D8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bn\u0010F\u00a8\u0006\u0085\u0001"}, d2={"Lorg/gjt/jclasslib/structures/ClassFile;", "Lorg/gjt/jclasslib/structures/Structure;", "Lorg/gjt/jclasslib/structures/AttributeContainer;", "<init>", "()V", "minorVersion", "", "getMinorVersion", "()I", "setMinorVersion", "(I)V", "majorVersion", "getMajorVersion", "setMajorVersion", "constantPool", "", "Lorg/gjt/jclasslib/structures/Constant;", "getConstantPool", "()[Lorg/gjt/jclasslib/structures/Constant;", "setConstantPool", "([Lorg/gjt/jclasslib/structures/Constant;)V", "[Lorg/gjt/jclasslib/structures/Constant;", "constantPoolEntryToIndex", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "accessFlags", "getAccessFlags", "setAccessFlags", "thisClass", "getThisClass", "setThisClass", "thisClassConstant", "Lorg/gjt/jclasslib/structures/constants/ConstantClassInfo;", "getThisClassConstant", "()Lorg/gjt/jclasslib/structures/constants/ConstantClassInfo;", "superClass", "getSuperClass", "setSuperClass", "superClassConstant", "getSuperClassConstant", "interfaces", "", "getInterfaces", "()[I", "setInterfaces", "([I)V", "fields", "Lorg/gjt/jclasslib/structures/FieldInfo;", "getFields", "()[Lorg/gjt/jclasslib/structures/FieldInfo;", "setFields", "([Lorg/gjt/jclasslib/structures/FieldInfo;)V", "[Lorg/gjt/jclasslib/structures/FieldInfo;", "methods", "Lorg/gjt/jclasslib/structures/MethodInfo;", "getMethods", "()[Lorg/gjt/jclasslib/structures/MethodInfo;", "setMethods", "([Lorg/gjt/jclasslib/structures/MethodInfo;)V", "[Lorg/gjt/jclasslib/structures/MethodInfo;", "attributes", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "getAttributes", "()[Lorg/gjt/jclasslib/structures/AttributeInfo;", "setAttributes", "([Lorg/gjt/jclasslib/structures/AttributeInfo;)V", "[Lorg/gjt/jclasslib/structures/AttributeInfo;", "majorVersionVerbose", "", "getMajorVersionVerbose", "()Ljava/lang/String;", "getConstantPoolIndex", "constant", "enlargeConstantPool", "", "enlargedConstantPool", "registerConstantPoolEntry", "index", "unregisterConstantPoolEntry", "thisClassName", "getThisClassName", "simpleClassName", "getSimpleClassName", "superClassName", "getSuperClassName", "formattedAccessFlags", "getFormattedAccessFlags", "accessFlagsVerbose", "getAccessFlagsVerbose", "getConstantPoolUtf8Entry", "Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "getConstantPoolEntry", "T", "entryClass", "Lkotlin/reflect/KClass;", "(ILkotlin/reflect/KClass;)Lorg/gjt/jclasslib/structures/Constant;", "getConstantPoolEntryName", "getFieldIndex", "name", "descriptor", "getField", "getMethodIndex", "getMethod", "readData", "input", "Lorg/gjt/jclasslib/io/DataInput;", "writeData", "output", "Lorg/gjt/jclasslib/io/DataOutput;", "debugInfo", "getDebugInfo", "checkValidConstantPoolIndex", "readMagicNumber", "writeMagicNumber", "readVersion", "writeVersion", "readConstantPool", "writeConstantPool", "readAccessFlags", "writeAccessFlags", "readThisClass", "writeThisClass", "readSuperClass", "writeSuperClass", "readInterfaces", "writeInterfaces", "readFields", "writeFields", "readMethods", "writeMethods", "checkMajorVersion", "KnownMajorJavaVersions", "Companion", "data"})
@SourceDebugExtension(value={"SMAP\nClassFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassFile.kt\norg/gjt/jclasslib/structures/ClassFile\n+ 2 Package.kt\norg/gjt/jclasslib/structures/Package\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,487:1\n77#2:488\n78#2:492\n79#2:497\n77#2:498\n78#2:502\n79#2:507\n77#2:508\n78#2:512\n79#2:517\n77#2:518\n78#2:522\n79#2:527\n382#3,3:489\n385#3,4:493\n382#3,3:499\n385#3,4:503\n382#3,3:509\n385#3,4:513\n382#3,3:519\n385#3,4:523\n13870#4,3:528\n13870#4,3:539\n13870#4,3:542\n13870#4,3:545\n13826#4,2:548\n13805#4,2:550\n13805#4,2:552\n295#5,2:531\n621#6,6:533\n*S KotlinDebug\n*F\n+ 1 ClassFile.kt\norg/gjt/jclasslib/structures/ClassFile\n*L\n35#1:488\n35#1:492\n35#1:497\n78#1:498\n78#1:502\n78#1:507\n83#1:508\n83#1:512\n83#1:517\n85#1:518\n85#1:522\n85#1:527\n35#1:489,3\n35#1:493,4\n78#1:499,3\n78#1:503,4\n83#1:509,3\n83#1:513,4\n85#1:519,3\n85#1:523,4\n38#1:528,3\n206#1:539,3\n230#1:542,3\n348#1:545,3\n402#1:548,2\n424#1:550,2\n444#1:552,2\n92#1:531,2\n144#1:533,6\n*E\n"})
public final class ClassFile
extends Structure
implements AttributeContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int minorVersion;
    private int majorVersion;
    @NotNull
    private Constant[] constantPool;
    @NotNull
    private final HashMap<Constant, Integer> constantPoolEntryToIndex;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    @NotNull
    private int[] interfaces;
    @NotNull
    private FieldInfo[] fields;
    @NotNull
    private MethodInfo[] methods;
    @NotNull
    private AttributeInfo[] attributes;
    private static final int MAGIC_NUMBER = -889275714;
    @NotNull
    private static final IntRange MAJOR_VERSION_RANGE = new IntRange(((KnownMajorJavaVersions)((Object)CollectionsKt.first((List)((List)KnownMajorJavaVersions.getEntries())))).getMajorVersion(), ((KnownMajorJavaVersions)((Object)CollectionsKt.last((List)((List)KnownMajorJavaVersions.getEntries())))).getMajorVersion());

    public ClassFile() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Structure[] answer$iv$iv;
        Map $this$getOrPut$iv$iv;
        boolean $i$f$emptyArraySingleton = false;
        Map map = Package.access$getArraySingletons$p();
        KClass key$iv$iv = Reflection.getOrCreateKotlinClass(Constant.class);
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            answer$iv$iv = new Constant[]{};
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object4 = answer$iv$iv;
        } else {
            object4 = value$iv$iv;
        }
        this.constantPool = (Constant[])((Object[])object4);
        this.constantPoolEntryToIndex = new HashMap();
        this.interfaces = new int[0];
        $i$f$emptyArraySingleton = false;
        $this$getOrPut$iv$iv = Package.access$getArraySingletons$p();
        key$iv$iv = Reflection.getOrCreateKotlinClass(FieldInfo.class);
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            answer$iv$iv = new FieldInfo[]{};
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object3 = answer$iv$iv;
        } else {
            object3 = value$iv$iv;
        }
        this.fields = (FieldInfo[])((Object[])object3);
        $i$f$emptyArraySingleton = false;
        $this$getOrPut$iv$iv = Package.access$getArraySingletons$p();
        key$iv$iv = Reflection.getOrCreateKotlinClass(MethodInfo.class);
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            answer$iv$iv = new MethodInfo[]{};
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        this.methods = (MethodInfo[])((Object[])object2);
        $i$f$emptyArraySingleton = false;
        $this$getOrPut$iv$iv = Package.access$getArraySingletons$p();
        key$iv$iv = Reflection.getOrCreateKotlinClass(AttributeInfo.class);
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            AttributeInfo[] answer$iv$iv2 = new AttributeInfo[]{};
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv2);
            object = answer$iv$iv2;
        } else {
            object = value$iv$iv;
        }
        this.attributes = (AttributeInfo[])((Object[])object);
    }

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public final void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    public final void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    @NotNull
    public final Constant[] getConstantPool() {
        return this.constantPool;
    }

    /*
     * WARNING - void declaration
     */
    public final void setConstantPool(@NotNull Constant[] constantPool) {
        Intrinsics.checkNotNullParameter((Object)constantPool, (String)"constantPool");
        this.constantPool = constantPool;
        Constant[] $this$forEachIndexed$iv = constantPool;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Constant item$iv : $this$forEachIndexed$iv) {
            void cpInfo;
            int n = index$iv++;
            Constant constant = item$iv;
            int i = n;
            boolean bl = false;
            ((Map)this.constantPoolEntryToIndex).put(cpInfo, i);
        }
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public final void setAccessFlags(int n) {
        this.accessFlags = n;
    }

    public final int getThisClass() {
        return this.thisClass;
    }

    public final void setThisClass(int n) {
        this.thisClass = n;
    }

    @NotNull
    public final ConstantClassInfo getThisClassConstant() {
        return (ConstantClassInfo)this.getConstantPoolEntry(this.thisClass, Reflection.getOrCreateKotlinClass(ConstantClassInfo.class));
    }

    public final int getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(int n) {
        this.superClass = n;
    }

    @NotNull
    public final ConstantClassInfo getSuperClassConstant() {
        return (ConstantClassInfo)this.getConstantPoolEntry(this.superClass, Reflection.getOrCreateKotlinClass(ConstantClassInfo.class));
    }

    @NotNull
    public final int[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.interfaces = nArray;
    }

    @NotNull
    public final FieldInfo[] getFields() {
        return this.fields;
    }

    public final void setFields(@NotNull FieldInfo[] fieldInfoArray) {
        Intrinsics.checkNotNullParameter((Object)fieldInfoArray, (String)"<set-?>");
        this.fields = fieldInfoArray;
    }

    @NotNull
    public final MethodInfo[] getMethods() {
        return this.methods;
    }

    public final void setMethods(@NotNull MethodInfo[] methodInfoArray) {
        Intrinsics.checkNotNullParameter((Object)methodInfoArray, (String)"<set-?>");
        this.methods = methodInfoArray;
    }

    @Override
    @NotNull
    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AttributeInfo[] attributeInfoArray) {
        Intrinsics.checkNotNullParameter((Object)attributeInfoArray, (String)"<set-?>");
        this.attributes = attributeInfoArray;
    }

    @NotNull
    public final String getMajorVersionVerbose() {
        Object object;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = (Iterable)KnownMajorJavaVersions.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KnownMajorJavaVersions it = (KnownMajorJavaVersions)((Object)element$iv);
                boolean bl = false;
                if (!(it.getMajorVersion() == this.majorVersion)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (KnownMajorJavaVersions)v0) == null || (object = object.getVerbose()) == null) {
            object = "unknown value " + this.majorVersion;
        }
        return object;
    }

    public final int getConstantPoolIndex(@NotNull Constant constant) {
        Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
        Integer n = this.constantPoolEntryToIndex.get(constant);
        return n != null ? n : -1;
    }

    public final void enlargeConstantPool(@NotNull Constant[] enlargedConstantPool) {
        Intrinsics.checkNotNullParameter((Object)enlargedConstantPool, (String)"enlargedConstantPool");
        int n = enlargedConstantPool.length;
        for (int i = this.constantPool.length; i < n; ++i) {
            ((Map)this.constantPoolEntryToIndex).put(enlargedConstantPool[i], i);
        }
        this.setConstantPool(enlargedConstantPool);
    }

    public final void registerConstantPoolEntry(int index) {
        ((Map)this.constantPoolEntryToIndex).put(this.constantPool[index], index);
    }

    public final void unregisterConstantPoolEntry(int index) {
        this.constantPoolEntryToIndex.remove(this.constantPool[index]);
    }

    @NotNull
    public final String getThisClassName() {
        return this.getConstantPoolEntryName(this.thisClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getSimpleClassName() {
        String string;
        block1: {
            void var1_1;
            String $this$takeLastWhile$iv = this.getThisClassName();
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it != '/') continue;
                String string2 = $this$takeLastWhile$iv;
                int n = index$iv + 1;
                String string3 = string2.substring(n);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var1_1;
        }
        return string;
    }

    @NotNull
    public final String getSuperClassName() {
        return this.getConstantPoolEntryName(this.superClass);
    }

    @NotNull
    public final String getFormattedAccessFlags() {
        return this.formatFlags(this.accessFlags);
    }

    @NotNull
    public final String getAccessFlagsVerbose() {
        return Structure.formatFlagsVerbose$default(this, AccessFlag.Companion.getCLASS_ACCESS_FLAGS(), this.accessFlags, null, 4, null);
    }

    @NotNull
    public final ConstantUtf8Info getConstantPoolUtf8Entry(int index) {
        return (ConstantUtf8Info)this.getConstantPoolEntry(index, Reflection.getOrCreateKotlinClass(ConstantUtf8Info.class));
    }

    @NotNull
    public final <T extends Constant> T getConstantPoolEntry(int index, @NotNull KClass<T> entryClass) {
        Intrinsics.checkNotNullParameter(entryClass, (String)"entryClass");
        this.checkValidConstantPoolIndex(index);
        Constant cpInfo = this.constantPool[index];
        if (!entryClass.isInstance((Object)cpInfo)) {
            throw new InvalidByteCodeException("constant pool entry at " + index + " of class " + Reflection.getOrCreateKotlinClass(cpInfo.getClass()) + " is not assignable to " + entryClass);
        }
        Intrinsics.checkNotNull((Object)cpInfo, (String)"null cannot be cast to non-null type T of org.gjt.jclasslib.structures.ClassFile.getConstantPoolEntry");
        return (T)cpInfo;
    }

    @NotNull
    public final String getConstantPoolEntryName(int index) {
        this.checkValidConstantPoolIndex(index);
        return this.constantPool[index].getVerbose();
    }

    /*
     * WARNING - void declaration
     */
    public final int getFieldIndex(@NotNull String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        FieldInfo[] $this$forEachIndexed$iv = this.fields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (FieldInfo item$iv : $this$forEachIndexed$iv) {
            void fieldInfo;
            int n = index$iv++;
            FieldInfo fieldInfo2 = item$iv;
            int i = n;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)fieldInfo.getName(), (Object)name) || !Intrinsics.areEqual((Object)fieldInfo.getDescriptor(), (Object)descriptor)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public final FieldInfo getField(@NotNull String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int index = this.getFieldIndex(name, descriptor);
        return index < 0 ? null : this.fields[index];
    }

    /*
     * WARNING - void declaration
     */
    public final int getMethodIndex(@NotNull String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        MethodInfo[] $this$forEachIndexed$iv = this.methods;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (MethodInfo item$iv : $this$forEachIndexed$iv) {
            void methodInfo;
            int n = index$iv++;
            MethodInfo methodInfo2 = item$iv;
            int i = n;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)methodInfo.getName(), (Object)name) || !Intrinsics.areEqual((Object)methodInfo.getDescriptor(), (Object)descriptor)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public final MethodInfo getMethod(@NotNull String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int index = this.getMethodIndex(name, descriptor);
        return index < 0 ? null : this.methods[index];
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.readMagicNumber(input);
        this.readVersion(input);
        this.readConstantPool(input);
        this.readAccessFlags(input);
        this.readThisClass(input);
        this.readSuperClass(input);
        this.readInterfaces(input);
        this.readFields(input);
        this.readMethods(input);
        this.readAttributes(this, input, this);
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.writeMagicNumber(output);
        this.writeVersion(output);
        this.writeConstantPool(output);
        this.writeAccessFlags(output);
        this.writeThisClass(output);
        this.writeSuperClass(output);
        this.writeInterfaces(output);
        this.writeFields(output);
        this.writeMethods(output);
        this.writeAttributes(this, output);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "";
    }

    private final void checkValidConstantPoolIndex(int index) {
        if (index < 1 || index >= this.constantPool.length) {
            throw new InvalidByteCodeException("Constant pool index " + index + " is out of bounds [1, " + (this.constantPool.length - 1) + "]");
        }
    }

    private final void readMagicNumber(DataInput input) {
        int magicNumber = input.readInt();
        if (magicNumber != -889275714) {
            throw new InvalidByteCodeException("Invalid magic number " + Package.getHex(magicNumber) + " instead of " + Package.getHex(-889275714));
        }
        if (Package.isDebug()) {
            Package.debug("read magic number", input);
        }
    }

    private final void writeMagicNumber(DataOutput output) {
        output.writeInt(-889275714);
        if (Package.isDebug()) {
            Package.debug("wrote magic number", output);
        }
    }

    private final void readVersion(DataInput input) {
        this.minorVersion = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read minor version " + this.minorVersion, input);
        }
        this.majorVersion = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read major version " + this.majorVersion, input);
        }
        this.checkMajorVersion(this.majorVersion);
    }

    private final void writeVersion(DataOutput output) {
        output.writeShort(this.minorVersion);
        if (Package.isDebug()) {
            Package.debug("wrote minor version " + this.minorVersion, output);
        }
        output.writeShort(this.majorVersion);
        if (Package.isDebug()) {
            Package.debug("wrote major version " + this.majorVersion, output);
        }
        this.checkMajorVersion(this.majorVersion);
    }

    /*
     * WARNING - void declaration
     */
    private final void readConstantPool(DataInput input) {
        this.constantPoolEntryToIndex.clear();
        int constantPoolCount = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read constant pool count " + constantPoolCount, input);
        }
        int placeholderIndex = 0;
        Constant[] constantArray = new Constant[constantPoolCount];
        ClassFile classFile = this;
        for (int i = 0; i < constantPoolCount; ++i) {
            Constant constant;
            int n = i;
            Constant[] constantArray2 = constantArray;
            int n2 = n;
            if (n == placeholderIndex) {
                constant = ConstantPlaceholder.INSTANCE;
            } else {
                void $this$readConstantPool_u24lambda_u240;
                Constant constant2;
                if (Package.isDebug()) {
                    Package.debug("reading constant pool entry " + n, input);
                }
                ConstantType constantType = (ConstantType)ConstantType.Companion.getFromTag(input.readByte());
                Constant constant3 = constant2 = constantType.read(this, input);
                int n3 = n2;
                Constant[] constantArray3 = constantArray2;
                boolean bl = false;
                ((Map)this.constantPoolEntryToIndex).put($this$readConstantPool_u24lambda_u240, n);
                int extraEntryCount = constantType.getExtraEntryCount();
                if (extraEntryCount > 0) {
                    placeholderIndex = n + extraEntryCount;
                }
                Unit unit = Unit.INSTANCE;
                constantArray2 = constantArray3;
                n2 = n3;
                constant = constant2;
            }
            constantArray2[n2] = constant;
        }
        classFile.setConstantPool(constantArray);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeConstantPool(DataOutput output) {
        output.writeShort(this.constantPool.length);
        if (Package.isDebug()) {
            Package.debug("wrote constant pool count " + this.constantPool.length, output);
        }
        Constant[] $this$forEachIndexed$iv = this.constantPool;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Constant item$iv : $this$forEachIndexed$iv) {
            void cpInfo;
            int n = index$iv++;
            Constant constant = item$iv;
            int i = n;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)cpInfo, (Object)ConstantPlaceholder.INSTANCE)) continue;
            if (Package.isDebug()) {
                Package.debug("writing constant pool entry " + i, output);
            }
            cpInfo.write(output);
        }
    }

    private final void readAccessFlags(DataInput input) {
        this.accessFlags = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read access flags " + this.getAccessFlagsVerbose(), input);
        }
    }

    private final void writeAccessFlags(DataOutput output) {
        output.writeShort(this.accessFlags);
        if (Package.isDebug()) {
            Package.debug("wrote access flags " + this.getAccessFlagsVerbose(), output);
        }
    }

    private final void readThisClass(DataInput input) {
        this.thisClass = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read this_class index " + this.thisClass, input);
        }
    }

    private final void writeThisClass(DataOutput output) {
        output.writeShort(this.thisClass);
        if (Package.isDebug()) {
            Package.debug("wrote this_class index " + this.thisClass, output);
        }
    }

    private final void readSuperClass(DataInput input) {
        this.superClass = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read super_class index " + this.superClass, input);
        }
    }

    private final void writeSuperClass(DataOutput output) {
        output.writeShort(this.superClass);
        if (Package.isDebug()) {
            Package.debug("wrote super_class index " + this.superClass, output);
        }
    }

    private final void readInterfaces(DataInput input) {
        int interfacesCount = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read interfaces count " + interfacesCount, input);
        }
        int[] nArray = new int[interfacesCount];
        ClassFile classFile = this;
        for (int i = 0; i < interfacesCount; ++i) {
            int n = i;
            int index = input.readUnsignedShort();
            if (Package.isDebug()) {
                Package.debug("read interface index " + index, input);
            }
            nArray[n] = index;
        }
        classFile.interfaces = nArray;
    }

    private final void writeInterfaces(DataOutput output) {
        int interfacesCount = this.interfaces.length;
        output.writeShort(interfacesCount);
        if (Package.isDebug()) {
            Package.debug("wrote interfaces count " + interfacesCount, output);
        }
        int[] $this$forEach$iv = this.interfaces;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            output.writeShort(it);
            if (!Package.isDebug()) continue;
            Package.debug("wrote interface index " + it, output);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readFields(DataInput input) {
        int fieldsCount = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read fields count " + fieldsCount, input);
        }
        int n = 0;
        FieldInfo[] fieldInfoArray = new FieldInfo[fieldsCount];
        ClassFile classFile = this;
        while (n < fieldsCount) {
            void $this$readFields_u24lambda_u240;
            FieldInfo fieldInfo;
            int n2 = n++;
            FieldInfo fieldInfo2 = fieldInfo = new FieldInfo(this);
            int n3 = n2;
            FieldInfo[] fieldInfoArray2 = fieldInfoArray;
            boolean bl = false;
            $this$readFields_u24lambda_u240.read(input);
            Unit unit = Unit.INSTANCE;
            fieldInfoArray2[n3] = fieldInfo;
        }
        classFile.fields = fieldInfoArray;
    }

    private final void writeFields(DataOutput output) {
        int fieldsCount = this.fields.length;
        output.writeShort(fieldsCount);
        if (Package.isDebug()) {
            Package.debug("wrote fields count " + fieldsCount, output);
        }
        FieldInfo[] $this$forEach$iv = this.fields;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            FieldInfo element$iv;
            FieldInfo it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.write(output);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readMethods(DataInput input) {
        int methodsCount = input.readUnsignedShort();
        if (Package.isDebug()) {
            Package.debug("read methods count " + methodsCount, input);
        }
        int n = 0;
        MethodInfo[] methodInfoArray = new MethodInfo[methodsCount];
        ClassFile classFile = this;
        while (n < methodsCount) {
            void $this$readMethods_u24lambda_u240;
            MethodInfo methodInfo;
            int n2 = n++;
            MethodInfo methodInfo2 = methodInfo = new MethodInfo(this);
            int n3 = n2;
            MethodInfo[] methodInfoArray2 = methodInfoArray;
            boolean bl = false;
            $this$readMethods_u24lambda_u240.read(input);
            Unit unit = Unit.INSTANCE;
            methodInfoArray2[n3] = methodInfo;
        }
        classFile.methods = methodInfoArray;
    }

    private final void writeMethods(DataOutput output) {
        int methodsCount = this.methods.length;
        output.writeShort(methodsCount);
        if (Package.isDebug()) {
            Package.debug("wrote methods count " + methodsCount, output);
        }
        MethodInfo[] $this$forEach$iv = this.methods;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MethodInfo element$iv;
            MethodInfo it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.write(output);
        }
    }

    private final void checkMajorVersion(int majorVersion) {
        if (Package.isMajorVersionWarnings()) {
            IntRange intRange = MAJOR_VERSION_RANGE;
            int n = intRange.getFirst();
            if (!(majorVersion <= intRange.getLast() ? n <= majorVersion : false)) {
                Package.warning("major version should be between " + MAJOR_VERSION_RANGE.getFirst() + " and " + MAJOR_VERSION_RANGE.getLast() + " for JDK <= " + ((KnownMajorJavaVersions)((Object)CollectionsKt.last((List)((List)KnownMajorJavaVersions.getEntries())))).getVerbose() + ", was " + majorVersion);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gjt/jclasslib/structures/ClassFile$Companion;", "", "<init>", "()V", "MAGIC_NUMBER", "", "MAJOR_VERSION_RANGE", "Lkotlin/ranges/IntRange;", "data"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b!\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%\u00a8\u0006&"}, d2={"Lorg/gjt/jclasslib/structures/ClassFile$KnownMajorJavaVersions;", "", "majorVersion", "", "verbose", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getMajorVersion", "()I", "getVerbose", "()Ljava/lang/String;", "V45", "V46", "V47", "V48", "V49", "V50", "V51", "V52", "V53", "V54", "V55", "V56", "V57", "V58", "V59", "V60", "V61", "V62", "V63", "V64", "V65", "V66", "V67", "V68", "V69", "V70", "data"})
    private static final class KnownMajorJavaVersions
    extends Enum<KnownMajorJavaVersions> {
        private final int majorVersion;
        @NotNull
        private final String verbose;
        public static final /* enum */ KnownMajorJavaVersions V45 = new KnownMajorJavaVersions(45, "1.1");
        public static final /* enum */ KnownMajorJavaVersions V46 = new KnownMajorJavaVersions(46, "1.2");
        public static final /* enum */ KnownMajorJavaVersions V47 = new KnownMajorJavaVersions(47, "1.3");
        public static final /* enum */ KnownMajorJavaVersions V48 = new KnownMajorJavaVersions(48, "1.4");
        public static final /* enum */ KnownMajorJavaVersions V49 = new KnownMajorJavaVersions(49, "1.5");
        public static final /* enum */ KnownMajorJavaVersions V50 = new KnownMajorJavaVersions(50, "1.6");
        public static final /* enum */ KnownMajorJavaVersions V51 = new KnownMajorJavaVersions(51, "1.7");
        public static final /* enum */ KnownMajorJavaVersions V52 = new KnownMajorJavaVersions(52, "1.8");
        public static final /* enum */ KnownMajorJavaVersions V53 = new KnownMajorJavaVersions(53, "9");
        public static final /* enum */ KnownMajorJavaVersions V54 = new KnownMajorJavaVersions(54, "10");
        public static final /* enum */ KnownMajorJavaVersions V55 = new KnownMajorJavaVersions(55, "11");
        public static final /* enum */ KnownMajorJavaVersions V56 = new KnownMajorJavaVersions(56, "12");
        public static final /* enum */ KnownMajorJavaVersions V57 = new KnownMajorJavaVersions(57, "13");
        public static final /* enum */ KnownMajorJavaVersions V58 = new KnownMajorJavaVersions(58, "14");
        public static final /* enum */ KnownMajorJavaVersions V59 = new KnownMajorJavaVersions(59, "15");
        public static final /* enum */ KnownMajorJavaVersions V60 = new KnownMajorJavaVersions(60, "16");
        public static final /* enum */ KnownMajorJavaVersions V61 = new KnownMajorJavaVersions(61, "17");
        public static final /* enum */ KnownMajorJavaVersions V62 = new KnownMajorJavaVersions(62, "18");
        public static final /* enum */ KnownMajorJavaVersions V63 = new KnownMajorJavaVersions(63, "19");
        public static final /* enum */ KnownMajorJavaVersions V64 = new KnownMajorJavaVersions(64, "20");
        public static final /* enum */ KnownMajorJavaVersions V65 = new KnownMajorJavaVersions(65, "21");
        public static final /* enum */ KnownMajorJavaVersions V66 = new KnownMajorJavaVersions(66, "22");
        public static final /* enum */ KnownMajorJavaVersions V67 = new KnownMajorJavaVersions(67, "23");
        public static final /* enum */ KnownMajorJavaVersions V68 = new KnownMajorJavaVersions(68, "24");
        public static final /* enum */ KnownMajorJavaVersions V69 = new KnownMajorJavaVersions(69, "25");
        public static final /* enum */ KnownMajorJavaVersions V70 = new KnownMajorJavaVersions(69, "26");
        private static final /* synthetic */ KnownMajorJavaVersions[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private KnownMajorJavaVersions(int majorVersion, String verbose) {
            this.majorVersion = majorVersion;
            this.verbose = verbose;
        }

        public final int getMajorVersion() {
            return this.majorVersion;
        }

        @NotNull
        public final String getVerbose() {
            return this.verbose;
        }

        public static KnownMajorJavaVersions[] values() {
            return (KnownMajorJavaVersions[])$VALUES.clone();
        }

        public static KnownMajorJavaVersions valueOf(String value) {
            return Enum.valueOf(KnownMajorJavaVersions.class, value);
        }

        @NotNull
        public static EnumEntries<KnownMajorJavaVersions> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = knownMajorJavaVersionsArray = new KnownMajorJavaVersions[]{KnownMajorJavaVersions.V45, KnownMajorJavaVersions.V46, KnownMajorJavaVersions.V47, KnownMajorJavaVersions.V48, KnownMajorJavaVersions.V49, KnownMajorJavaVersions.V50, KnownMajorJavaVersions.V51, KnownMajorJavaVersions.V52, KnownMajorJavaVersions.V53, KnownMajorJavaVersions.V54, KnownMajorJavaVersions.V55, KnownMajorJavaVersions.V56, KnownMajorJavaVersions.V57, KnownMajorJavaVersions.V58, KnownMajorJavaVersions.V59, KnownMajorJavaVersions.V60, KnownMajorJavaVersions.V61, KnownMajorJavaVersions.V62, KnownMajorJavaVersions.V63, KnownMajorJavaVersions.V64, KnownMajorJavaVersions.V65, KnownMajorJavaVersions.V66, KnownMajorJavaVersions.V67, KnownMajorJavaVersions.V68, KnownMajorJavaVersions.V69, KnownMajorJavaVersions.V70};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

