/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.files.PathsJvmKt;
import org.gjt.jclasslib.io.ClassFileIOKt;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/gjt/jclasslib/io/ClassFileWriter;", "", "<init>", "()V", "writeToFile", "", "file", "Ljava/io/File;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "path", "Ljava/nio/file/Path;", "writeToByteArray", "", "data"})
public final class ClassFileWriter {
    @NotNull
    public static final ClassFileWriter INSTANCE = new ClassFileWriter();

    private ClassFileWriter() {
    }

    @JvmStatic
    public static final void writeToFile(@NotNull File file, @NotNull ClassFile classFile) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        ClassFileIOKt.writeToPath(classFile, PathsJvmKt.Path((String)string));
    }

    @JvmStatic
    public static final void writeToFile(@NotNull Path path, @NotNull ClassFile classFile) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        ClassFileIOKt.writeToPath(classFile, PathsJvmKt.Path((String)((Object)path).toString()));
    }

    @JvmStatic
    @NotNull
    public static final byte[] writeToByteArray(@NotNull ClassFile classFile) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        return ClassFileIOKt.writeToByteArray(classFile);
    }
}

