/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserFrame;
import org.gjt.jclasslib.util.GUIHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0001J\b\u0010\u0016\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gjt/jclasslib/browser/RecentMenu;", "Ljavax/swing/JMenu;", "frame", "Lorg/gjt/jclasslib/browser/BrowserFrame;", "<init>", "(Lorg/gjt/jclasslib/browser/BrowserFrame;)V", "recentWorkspaces", "Ljava/util/LinkedList;", "", "menuSelectionChanged", "", "isIncluded", "", "addRecentWorkspace", "file", "Ljava/io/File;", "read", "preferences", "Ljava/util/prefs/Preferences;", "save", "addTo", "parentMenu", "updateContents", "Companion", "browser"})
@SourceDebugExtension(value={"SMAP\nRecentMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentMenu.kt\norg/gjt/jclasslib/browser/RecentMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1869#2,2:129\n*S KotlinDebug\n*F\n+ 1 RecentMenu.kt\norg/gjt/jclasslib/browser/RecentMenu\n*L\n105#1:129,2\n*E\n"})
public final class RecentMenu
extends JMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserFrame frame;
    @NotNull
    private final LinkedList<String> recentWorkspaces;
    private static final int RECENT_PROJECTS_MAX_SIZE = 10;
    @NotNull
    private static final String SETTINGS_RECENT_WORKSPACES = "recentWorkspaces";

    public RecentMenu(@NotNull BrowserFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.frame = frame;
        this.recentWorkspaces = new LinkedList();
        this.setText(BrowserBundle.INSTANCE.getString("menu.recent.workspaces", new Object[0]));
        this.setIcon(GUIHelper.INSTANCE.getICON_EMPTY());
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        this.updateContents();
    }

    public final void addRecentWorkspace(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            LinkedList<String> linkedList;
            String fileName = file.getCanonicalFile().getAbsolutePath();
            LinkedList<String> $this$addRecentWorkspace_u24lambda_u240 = linkedList = this.recentWorkspaces;
            boolean bl = false;
            $this$addRecentWorkspace_u24lambda_u240.remove(fileName);
            $this$addRecentWorkspace_u24lambda_u240.addFirst(fileName);
            if ($this$addRecentWorkspace_u24lambda_u240.size() > 10) {
                $this$addRecentWorkspace_u24lambda_u240.removeLast();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void read(@NotNull Preferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        this.recentWorkspaces.clear();
        TreeMap numberToFile = new TreeMap();
        Preferences recentNode = preferences.node(SETTINGS_RECENT_WORKSPACES);
        try {
            String[] stringArray = recentNode.keys();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"keys(...)");
            for (String key : stringArray) {
                String fileName = recentNode.get(key, null);
                if (fileName == null) continue;
                ((Map)numberToFile).put(Integer.parseInt(key), fileName);
            }
            this.recentWorkspaces.addAll(numberToFile.values());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void save(@NotNull Preferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        Preferences recentNode = preferences.node(SETTINGS_RECENT_WORKSPACES);
        try {
            recentNode.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        Iterator iterator = ((Iterable)this.recentWorkspaces).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int count = n++;
            String fileName = (String)iterator.next();
            recentNode.put(String.valueOf(count), fileName);
        }
    }

    public final void addTo(@NotNull JMenu parentMenu) {
        Intrinsics.checkNotNullParameter((Object)parentMenu, (String)"parentMenu");
        parentMenu.addMenuListener(new MenuListener(this){
            final /* synthetic */ RecentMenu this$0;
            {
                this.this$0 = $receiver;
            }

            public void menuSelected(MenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RecentMenu.access$updateContents(this.this$0);
            }

            public void menuCanceled(MenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void menuDeselected(MenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        parentMenu.add(this);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateContents() {
        JMenuItem jMenuItem;
        this.removeAll();
        if (!((Collection)this.recentWorkspaces).isEmpty()) {
            void $this$updateContents_u24lambda_u242;
            ActionListener workspaceOpenListener = arg_0 -> RecentMenu.updateContents$lambda$0(this, arg_0);
            Object $this$forEach$iv = this.recentWorkspaces;
            boolean $i$f$forEach22 = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                void $this$updateContents_u24lambda_u241_u240;
                JMenuItem jMenuItem2;
                Object element$iv = iterator.next();
                String fileName = (String)element$iv;
                boolean bl = false;
                JMenuItem jMenuItem3 = jMenuItem2 = new JMenuItem(fileName);
                RecentMenu recentMenu = this;
                boolean bl2 = false;
                $this$updateContents_u24lambda_u241_u240.addActionListener(workspaceOpenListener);
                recentMenu.add(jMenuItem2);
            }
            this.addSeparator();
            Object $i$f$forEach22 = $this$forEach$iv = new JMenuItem(BrowserBundle.INSTANCE.getString("action.clear.list", new Object[0]));
            RecentMenu recentMenu = this;
            boolean bl = false;
            $this$updateContents_u24lambda_u242.addActionListener(arg_0 -> RecentMenu.updateContents$lambda$2$0(this, arg_0));
            jMenuItem = recentMenu.add((JMenuItem)$this$forEach$iv);
        } else {
            void $this$updateContents_u24lambda_u243;
            JMenuItem jMenuItem4;
            JMenuItem $this$forEach$iv = jMenuItem4 = new JMenuItem(BrowserBundle.INSTANCE.getString("menu.empty.placeholder", new Object[0]));
            RecentMenu recentMenu = this;
            boolean bl = false;
            $this$updateContents_u24lambda_u243.setEnabled(false);
            jMenuItem = recentMenu.add(jMenuItem4);
        }
    }

    private static final void updateContents$lambda$0(RecentMenu this$0, ActionEvent event) {
        this$0.setPopupMenuVisible(false);
        EventQueue.invokeLater(() -> RecentMenu.updateContents$lambda$0$0(this$0, event));
    }

    private static final void updateContents$lambda$0$0(RecentMenu this$0, ActionEvent $event) {
        BrowserFrame browserFrame = this$0.frame;
        Object object = $event.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JMenuItem");
        BrowserFrame.openWorkspace$default(browserFrame, new File(((JMenuItem)object).getText()), false, 2, null);
    }

    private static final void updateContents$lambda$2$0(RecentMenu this$0, ActionEvent it) {
        this$0.recentWorkspaces.clear();
    }

    public static final /* synthetic */ void access$updateContents(RecentMenu $this) {
        $this.updateContents();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gjt/jclasslib/browser/RecentMenu$Companion;", "", "<init>", "()V", "RECENT_PROJECTS_MAX_SIZE", "", "SETTINGS_RECENT_WORKSPACES", "", "browser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

