/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.dom.DomKt;
import kotlinx.dom.build.BuilderKt;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserFrame;
import org.gjt.jclasslib.browser.BrowserTab;
import org.gjt.jclasslib.browser.BrowserTabbedPane;
import org.gjt.jclasslib.browser.SplitMode;
import org.gjt.jclasslib.browser.config.BrowserPath;
import org.gjt.jclasslib.util.AlertFacadeKt;
import org.gjt.jclasslib.util.AlertType;
import org.gjt.jclasslib.util.DefaultAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import util.LightOrDarkColor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 E2\u00020\u0001:\u0003CDEB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u001aJ\u0006\u0010$\u001a\u00020\u001aJ\u000e\u0010%\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)2\u0006\u0010.\u001a\u00020)H\u0002J\u0018\u0010/\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020)2\u0006\u0010.\u001a\u00020)H\u0002J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020'2\u0006\u0010.\u001a\u00020'H\u0002J\u0010\u00100\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020-H\u0002J\u0010\u00103\u001a\u0004\u0018\u00010\u00162\u0006\u00104\u001a\u000205J$\u00109\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\b\b\u0002\u0010:\u001a\u0002052\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<J\u000e\u0010=\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?J#\u0010A\u001a\u00060\nR\u00020\u0000*\f\u0012\b\u0012\u00060\nR\u00020\u00000\t2\u0006\u0010B\u001a\u00020-H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\f\u0012\b\u0012\u00060\nR\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u00106\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006F"}, d2={"Lorg/gjt/jclasslib/browser/FrameContent;", "Ljavax/swing/JPanel;", "frame", "Lorg/gjt/jclasslib/browser/BrowserFrame;", "<init>", "(Lorg/gjt/jclasslib/browser/BrowserFrame;)V", "getFrame", "()Lorg/gjt/jclasslib/browser/BrowserFrame;", "wrappers", "", "Lorg/gjt/jclasslib/browser/FrameContent$TabbedPaneWrapper;", "getWrappers", "()Ljava/util/List;", "splitMode", "Lorg/gjt/jclasslib/browser/SplitMode;", "focusedTabbedPane", "Lorg/gjt/jclasslib/browser/BrowserTabbedPane;", "getFocusedTabbedPane", "()Lorg/gjt/jclasslib/browser/BrowserTabbedPane;", "setFocusedTabbedPane", "(Lorg/gjt/jclasslib/browser/BrowserTabbedPane;)V", "selectedTab", "Lorg/gjt/jclasslib/browser/BrowserTab;", "getSelectedTab", "()Lorg/gjt/jclasslib/browser/BrowserTab;", "saveClassesToDirectory", "", "directory", "Ljava/io/File;", "focus", "closeAllTabs", "", "force", "canClose", "hasModified", "updateSaveAction", "saveModified", "split", "getComponent", "Ljavax/swing/JComponent;", "splitPane", "Ljavax/swing/JSplitPane;", "splitConstant", "", "first", "Lorg/gjt/jclasslib/browser/FrameContent$Position;", "second", "coupleDividers", "transferTabs", "sourcePosition", "targetPosition", "findTab", "fileName", "", "totalTabCount", "getTotalTabCount", "()I", "openClassFile", "moduleName", "browserPath", "Lorg/gjt/jclasslib/browser/config/BrowserPath;", "saveWorkspace", "element", "Lorg/w3c/dom/Element;", "readWorkspace", "get", "position", "Position", "TabbedPaneWrapper", "Companion", "browser"})
@SourceDebugExtension(value={"SMAP\nFrameContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameContent.kt\norg/gjt/jclasslib/browser/FrameContent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n1563#2:285\n1634#2,3:286\n1374#2:289\n1460#2,5:290\n1563#2:295\n1634#2,3:296\n1788#2,4:299\n1869#2,2:303\n1740#2,3:305\n1761#2,3:308\n1374#2:313\n1460#2,5:314\n295#2,2:319\n774#2:322\n865#2,2:323\n216#3,2:311\n1#4:321\n*S KotlinDebug\n*F\n+ 1 FrameContent.kt\norg/gjt/jclasslib/browser/FrameContent\n*L\n30#1:285\n30#1:286,3\n45#1:289\n45#1:290,5\n46#1:295\n46#1:296,3\n46#1:299,4\n57#1:303,2\n65#1:305,3\n66#1:308,3\n162#1:313\n162#1:314,5\n162#1:319,2\n173#1:322\n173#1:323,2\n87#1:311,2\n*E\n"})
public final class FrameContent
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserFrame frame;
    @NotNull
    private final List<TabbedPaneWrapper> wrappers;
    @NotNull
    private SplitMode splitMode;
    @NotNull
    private BrowserTabbedPane focusedTabbedPane;
    @NotNull
    public static final String CARD_EMPTY = "empty";
    @NotNull
    public static final String CARD_TABBED_PANE = "tabbedPane";
    @NotNull
    private static final Dimension PREFERRED_SIZE = new Dimension(100, 100);
    @NotNull
    private static final LightOrDarkColor EMPTY_BACKGROUND = new LightOrDarkColor(new Color(210, 210, 210), new Color(80, 80, 80));
    @NotNull
    private static final Lazy<String> TABBED_PANE_EMPTY_MESSAGE$delegate = LazyKt.lazy(FrameContent::TABBED_PANE_EMPTY_MESSAGE_delegate$lambda$0);
    @NotNull
    private static final String NODE_NAME_TABS = "tabs";
    @NotNull
    private static final String ATTRIBUTE_SPLIT_MODE = "splitMode";
    @NotNull
    private static final String NODE_NAME_GROUP = "group";
    @NotNull
    private static final String ATTRIBUTE_POSITION = "position";

    /*
     * WARNING - void declaration
     */
    public FrameContent(@NotNull BrowserFrame frame) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.frame = frame;
        Iterable iterable = (Iterable)Position.getEntries();
        FrameContent frameContent = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Position position = (Position)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TabbedPaneWrapper((Position)it));
        }
        frameContent.wrappers = (List)destination$iv$iv;
        this.splitMode = SplitMode.NONE;
        this.focusedTabbedPane = this.get(this.wrappers, Position.NW).getTabbedPane();
        this.setLayout(new BorderLayout());
        this.split(SplitMode.NONE);
    }

    @NotNull
    public final BrowserFrame getFrame() {
        return this.frame;
    }

    @NotNull
    public final List<TabbedPaneWrapper> getWrappers() {
        return this.wrappers;
    }

    @NotNull
    public final BrowserTabbedPane getFocusedTabbedPane() {
        return this.focusedTabbedPane;
    }

    public final void setFocusedTabbedPane(@NotNull BrowserTabbedPane browserTabbedPane) {
        Intrinsics.checkNotNullParameter((Object)browserTabbedPane, (String)"<set-?>");
        this.focusedTabbedPane = browserTabbedPane;
    }

    @Nullable
    public final BrowserTab getSelectedTab() {
        return this.focusedTabbedPane.getSelectedTab();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveClassesToDirectory(@NotNull File directory) {
        int n;
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        TabbedPaneWrapper it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Iterable $this$flatMap$iv = this.wrappers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (TabbedPaneWrapper)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getTabbedPane().tabs();
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (BrowserTab)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((BrowserTab)((Object)it)).saveClassToDirectory(directory));
        }
        Iterable $this$count$iv = (List)destination$iv$iv;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean it2 = (Boolean)element$iv;
                boolean bl = false;
                if (!it2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        Object[] objectArray = new Object[]{count, directory};
        AlertFacadeKt.getAlertFacade().showMessage(this.frame, BrowserBundle.INSTANCE.getString("message.classes.saved.info", objectArray), AlertType.INFORMATION);
    }

    public final void focus(@NotNull BrowserTabbedPane focusedTabbedPane) {
        Intrinsics.checkNotNullParameter((Object)focusedTabbedPane, (String)"focusedTabbedPane");
        this.focusedTabbedPane = focusedTabbedPane;
    }

    public final boolean closeAllTabs(boolean force) {
        boolean bl;
        if (force || this.canClose()) {
            Iterable $this$forEach$iv = this.wrappers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TabbedPaneWrapper it = (TabbedPaneWrapper)element$iv;
                boolean bl2 = false;
                it.getTabbedPane().removeAll();
            }
            this.split(SplitMode.NONE);
            this.updateSaveAction();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean closeAllTabs$default(FrameContent frameContent, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return frameContent.closeAllTabs(bl);
    }

    public final boolean canClose() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.wrappers;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TabbedPaneWrapper it = (TabbedPaneWrapper)element$iv;
                    boolean bl2 = false;
                    if (it.getTabbedPane().canClose()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean hasModified() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.wrappers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TabbedPaneWrapper it = (TabbedPaneWrapper)element$iv;
                    boolean bl2 = false;
                    if (!it.getTabbedPane().hasModified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void updateSaveAction() {
        this.frame.getSaveModifiedClassesAction().setEnabled(this.hasModified());
    }

    public final void saveModified() {
        for (TabbedPaneWrapper wrapper : this.wrappers) {
            for (BrowserTab browserTab : wrapper.getTabbedPane().tabs()) {
                browserTab.saveModified();
            }
        }
        this.updateSaveAction();
    }

    public final void split(@NotNull SplitMode splitMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)splitMode), (String)ATTRIBUTE_SPLIT_MODE);
        this.removeAll();
        this.transferTabs(splitMode);
        this.add((Component)this.getComponent(splitMode), "Center");
        this.get(this.wrappers, Position.NW).focus();
        this.splitMode = splitMode;
        Map<SplitMode, DefaultAction> $this$forEach$iv = this.frame.getSplitActions();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<SplitMode, DefaultAction>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SplitMode, DefaultAction> element$iv;
            Map.Entry<SplitMode, DefaultAction> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().setEnabled(it.getKey() != splitMode);
        }
        this.revalidate();
    }

    private final JComponent getComponent(SplitMode splitMode) {
        JComponent jComponent;
        switch (WhenMappings.$EnumSwitchMapping$0[splitMode.ordinal()]) {
            case 1: {
                jComponent = this.get(this.wrappers, Position.NW);
                break;
            }
            case 2: {
                jComponent = this.splitPane(1, Position.NW, Position.NE);
                break;
            }
            case 3: {
                jComponent = this.splitPane(0, Position.NW, Position.SW);
                break;
            }
            case 4: {
                jComponent = this.splitPane(0, this.splitPane(1, Position.NW, Position.NE), this.splitPane(1, Position.SW, Position.SE));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jComponent;
    }

    private final JSplitPane splitPane(int splitConstant, Position first, Position second) {
        return this.splitPane(splitConstant, this.get(this.wrappers, first), this.get(this.wrappers, second));
    }

    private final JSplitPane splitPane(int splitConstant, JSplitPane first, JSplitPane second) {
        this.coupleDividers(first, second);
        this.coupleDividers(second, first);
        Intrinsics.checkNotNull((Object)first, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent jComponent = first;
        Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        return this.splitPane(splitConstant, jComponent, (JComponent)second);
    }

    private final void coupleDividers(JSplitPane first, JSplitPane second) {
        first.addPropertyChangeListener("dividerLocation", arg_0 -> FrameContent.coupleDividers$lambda$0(second, first, arg_0));
    }

    private final JSplitPane splitPane(int splitConstant, JComponent first, JComponent second) {
        JSplitPane jSplitPane;
        JSplitPane $this$splitPane_u24lambda_u240 = jSplitPane = new JSplitPane(splitConstant, first, second);
        boolean bl = false;
        $this$splitPane_u24lambda_u240.setContinuousLayout(true);
        $this$splitPane_u24lambda_u240.setResizeWeight(0.5);
        $this$splitPane_u24lambda_u240.setOpaque(true);
        return jSplitPane;
    }

    private final void transferTabs(SplitMode splitMode) {
        Pair pair = TuplesKt.to((Object)((Object)this.splitMode), (Object)((Object)splitMode));
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)SplitMode.VERTICAL), (Object)((Object)SplitMode.NONE))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)SplitMode.HORIZONTAL), (Object)((Object)SplitMode.NONE))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)SplitMode.BOTH), (Object)((Object)SplitMode.NONE)))) {
            this.transferTabs(Position.NE, Position.NW);
            this.transferTabs(Position.SE, Position.NW);
            this.transferTabs(Position.SW, Position.NW);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)SplitMode.VERTICAL), (Object)((Object)SplitMode.HORIZONTAL)))) {
            this.transferTabs(Position.SW, Position.NE);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)SplitMode.HORIZONTAL), (Object)((Object)SplitMode.VERTICAL)))) {
            this.transferTabs(Position.NE, Position.SW);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)SplitMode.BOTH), (Object)((Object)SplitMode.HORIZONTAL)))) {
            this.transferTabs(Position.SW, Position.NW);
            this.transferTabs(Position.SE, Position.NE);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)SplitMode.BOTH), (Object)((Object)SplitMode.VERTICAL)))) {
            this.transferTabs(Position.NE, Position.NW);
            this.transferTabs(Position.SE, Position.SW);
        }
    }

    private final void transferTabs(Position sourcePosition, Position targetPosition) {
        this.get(this.wrappers, targetPosition).transferTabsFrom(this.get(this.wrappers, sourcePosition));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BrowserTab findTab(@NotNull String fileName) {
        Object v0;
        block2: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Iterable $this$flatMap$iv = this.wrappers;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TabbedPaneWrapper it = (TabbedPaneWrapper)element$iv$iv;
                boolean bl = false;
                Iterable<BrowserTab> list$iv$iv = it.getTabbedPane().tabs();
                CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BrowserTab it = (BrowserTab)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)fileName)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public final int getTotalTabCount() {
        Iterable iterable = this.wrappers;
        int n = 0;
        for (Object t : iterable) {
            void it;
            TabbedPaneWrapper tabbedPaneWrapper = (TabbedPaneWrapper)t;
            int n2 = n;
            boolean bl = false;
            int n3 = CollectionsKt.count(it.getTabbedPane().tabs());
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public final BrowserTab openClassFile(@NotNull String fileName, @NotNull String moduleName, @Nullable BrowserPath browserPath) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return this.focusedTabbedPane.addTab(fileName, moduleName, browserPath);
    }

    public static /* synthetic */ BrowserTab openClassFile$default(FrameContent frameContent, String string, String string2, BrowserPath browserPath, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "<unnamed module>";
        }
        if ((n & 4) != 0) {
            browserPath = null;
        }
        return frameContent.openClassFile(string, string2, browserPath);
    }

    public final void saveWorkspace(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BuilderKt.addElement$default((Element)element, (String)NODE_NAME_TABS, null, arg_0 -> FrameContent.saveWorkspace$lambda$0(this, arg_0), (int)2, null);
    }

    public final void readWorkspace(@NotNull Element element) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element element2 = DomKt.firstChildElement((Element)element, (String)NODE_NAME_TABS);
            if (element2 == null) break block1;
            Element tabsElement = element2;
            boolean bl = false;
            this.split(SplitMode.Companion.getByName(tabsElement.getAttribute(ATTRIBUTE_SPLIT_MODE)));
            for (Element groupElement : DomKt.childElements((Element)tabsElement, (String)NODE_NAME_GROUP)) {
                Position position = Position.Companion.getByName(groupElement.getAttribute(ATTRIBUTE_POSITION));
                this.get(this.wrappers, position).readWorkspace(groupElement);
            }
        }
    }

    @NotNull
    public final TabbedPaneWrapper get(@NotNull List<TabbedPaneWrapper> $this$get, @NotNull Position position) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)ATTRIBUTE_POSITION);
        return $this$get.get(position.ordinal());
    }

    private static final void coupleDividers$lambda$0(JSplitPane $second, JSplitPane $first, PropertyChangeEvent it) {
        $second.setDividerLocation($first.getDividerLocation());
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit saveWorkspace$lambda$0(FrameContent this$0, Element $this$addElement) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addElement, (String)"$this$addElement");
        $this$addElement.setAttribute(ATTRIBUTE_SPLIT_MODE, this$0.splitMode.name());
        Iterable $this$filter$iv = this$0.wrappers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TabbedPaneWrapper it = (TabbedPaneWrapper)element$iv$iv;
            boolean bl = false;
            if (!it.isShowing()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (TabbedPaneWrapper wrapper : (List)destination$iv$iv) {
            wrapper.saveWorkspace($this$addElement);
        }
        return Unit.INSTANCE;
    }

    private static final String TABBED_PANE_EMPTY_MESSAGE_delegate$lambda$0() {
        return BrowserBundle.INSTANCE.getString("window.drag.class.file.label", new Object[0]);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gjt/jclasslib/browser/FrameContent$Companion;", "", "<init>", "()V", "CARD_EMPTY", "", "CARD_TABBED_PANE", "PREFERRED_SIZE", "Ljava/awt/Dimension;", "getPREFERRED_SIZE", "()Ljava/awt/Dimension;", "EMPTY_BACKGROUND", "Lutil/LightOrDarkColor;", "getEMPTY_BACKGROUND", "()Lutil/LightOrDarkColor;", "TABBED_PANE_EMPTY_MESSAGE", "getTABBED_PANE_EMPTY_MESSAGE", "()Ljava/lang/String;", "TABBED_PANE_EMPTY_MESSAGE$delegate", "Lkotlin/Lazy;", "NODE_NAME_TABS", "ATTRIBUTE_SPLIT_MODE", "NODE_NAME_GROUP", "ATTRIBUTE_POSITION", "browser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dimension getPREFERRED_SIZE() {
            return PREFERRED_SIZE;
        }

        @NotNull
        public final LightOrDarkColor getEMPTY_BACKGROUND() {
            return EMPTY_BACKGROUND;
        }

        @NotNull
        public final String getTABBED_PANE_EMPTY_MESSAGE() {
            Lazy lazy = TABBED_PANE_EMPTY_MESSAGE$delegate;
            return (String)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0015\b\u0002\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lorg/gjt/jclasslib/browser/FrameContent$Position;", "", "noneOpenMessage", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getNoneOpenMessage", "()Ljava/lang/String;", "NW", "NE", "SE", "SW", "Companion", "browser"})
    public static final class Position
    extends Enum<Position> {
        @NotNull
        public static final Companion Companion;
        @Nullable
        private final String noneOpenMessage;
        public static final /* enum */ Position NW;
        public static final /* enum */ Position NE;
        public static final /* enum */ Position SE;
        public static final /* enum */ Position SW;
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Position(String noneOpenMessage) {
            this.noneOpenMessage = noneOpenMessage;
        }

        /* synthetic */ Position(String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string2 = null;
            }
            this(string2);
        }

        @Nullable
        public final String getNoneOpenMessage() {
            return this.noneOpenMessage;
        }

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            NW = new Position(BrowserBundle.INSTANCE.getString("window.open.class.file.label", new Object[0]));
            NE = new Position("NE", 1, null, 1, null);
            SE = new Position("SE", 2, null, 1, null);
            SW = new Position("SW", 3, null, 1, null);
            $VALUES = positionArray = new Position[]{Position.NW, Position.NE, Position.SE, Position.SW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/gjt/jclasslib/browser/FrameContent$Position$Companion;", "", "<init>", "()V", "getByName", "Lorg/gjt/jclasslib/browser/FrameContent$Position;", "name", "", "browser"})
        @SourceDebugExtension(value={"SMAP\nFrameContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameContent.kt\norg/gjt/jclasslib/browser/FrameContent$Position$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n295#2,2:285\n*S KotlinDebug\n*F\n+ 1 FrameContent.kt\norg/gjt/jclasslib/browser/FrameContent$Position$Companion\n*L\n196#1:285,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Position getByName(@Nullable String name) {
                Position position;
                Object v0;
                block2: {
                    Iterable $this$firstOrNull$iv = (Iterable)Position.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Position it = (Position)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)name)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((position = (Position)v0) == null) {
                    position = NW;
                }
                return position;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0002J\u0012\u0010\u0018\u001a\u00020\u00112\n\u0010\u0019\u001a\u00060\u0000R\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u0011J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gjt/jclasslib/browser/FrameContent$TabbedPaneWrapper;", "Ljavax/swing/JPanel;", "position", "Lorg/gjt/jclasslib/browser/FrameContent$Position;", "<init>", "(Lorg/gjt/jclasslib/browser/FrameContent;Lorg/gjt/jclasslib/browser/FrameContent$Position;)V", "getPosition", "()Lorg/gjt/jclasslib/browser/FrameContent$Position;", "tabbedPane", "Lorg/gjt/jclasslib/browser/BrowserTabbedPane;", "getTabbedPane", "()Lorg/gjt/jclasslib/browser/BrowserTabbedPane;", "cardLayout", "Ljava/awt/CardLayout;", "messageLabel", "Ljavax/swing/JLabel;", "updateMessageLabel", "", "showCard", "cardName", "", "createEmptyPanel", "Ljavax/swing/Box;", "kotlin.jvm.PlatformType", "transferTabsFrom", "other", "Lorg/gjt/jclasslib/browser/FrameContent;", "getPreferredSize", "Ljava/awt/Dimension;", "focus", "saveWorkspace", "element", "Lorg/w3c/dom/Element;", "readWorkspace", "browser"})
    @SourceDebugExtension(value={"SMAP\nFrameContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameContent.kt\norg/gjt/jclasslib/browser/FrameContent$TabbedPaneWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1869#2,2:285\n*S KotlinDebug\n*F\n+ 1 FrameContent.kt\norg/gjt/jclasslib/browser/FrameContent$TabbedPaneWrapper\n*L\n204#1:285,2\n*E\n"})
    public final class TabbedPaneWrapper
    extends JPanel {
        @NotNull
        private final Position position;
        @NotNull
        private final BrowserTabbedPane tabbedPane;
        @NotNull
        private final CardLayout cardLayout;
        @NotNull
        private final JLabel messageLabel;

        /*
         * WARNING - void declaration
         */
        public TabbedPaneWrapper(Position position) {
            void $this$tabbedPane_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)((Object)position), (String)FrameContent.ATTRIBUTE_POSITION);
            this.position = position;
            BrowserTabbedPane browserTabbedPane = new BrowserTabbedPane(FrameContent.this);
            FrameContent frameContent = FrameContent.this;
            BrowserTabbedPane browserTabbedPane2 = browserTabbedPane;
            TabbedPaneWrapper tabbedPaneWrapper = this;
            boolean bl = false;
            $this$tabbedPane_u24lambda_u240.addChangeListener(arg_0 -> TabbedPaneWrapper.tabbedPane$lambda$0$0(this, (BrowserTabbedPane)$this$tabbedPane_u24lambda_u240, frameContent, arg_0));
            tabbedPaneWrapper.tabbedPane = browserTabbedPane;
            this.cardLayout = new CardLayout();
            String string = this.position.getNoneOpenMessage();
            if (string == null) {
                string = Companion.getTABBED_PANE_EMPTY_MESSAGE();
            }
            this.messageLabel = new JLabel(string);
            this.setLayout(this.cardLayout);
            this.add((Component)this.createEmptyPanel(), FrameContent.CARD_EMPTY);
            this.add((Component)this.tabbedPane, FrameContent.CARD_TABBED_PANE);
            this.showCard(FrameContent.CARD_EMPTY);
        }

        @NotNull
        public final Position getPosition() {
            return this.position;
        }

        @NotNull
        public final BrowserTabbedPane getTabbedPane() {
            return this.tabbedPane;
        }

        private final void updateMessageLabel() {
            String string;
            if (FrameContent.this.getTotalTabCount() > 0) {
                string = Companion.getTABBED_PANE_EMPTY_MESSAGE();
            } else {
                string = this.position.getNoneOpenMessage();
                if (string == null) {
                    string = Companion.getTABBED_PANE_EMPTY_MESSAGE();
                }
            }
            this.messageLabel.setText(string);
        }

        private final void showCard(String cardName) {
            this.cardLayout.show(this, cardName);
        }

        private final Box createEmptyPanel() {
            Box box;
            Box $this$createEmptyPanel_u24lambda_u240 = box = Box.createHorizontalBox();
            boolean bl = false;
            $this$createEmptyPanel_u24lambda_u240.add(Box.createHorizontalGlue());
            $this$createEmptyPanel_u24lambda_u240.add(this.messageLabel);
            $this$createEmptyPanel_u24lambda_u240.add(Box.createHorizontalGlue());
            $this$createEmptyPanel_u24lambda_u240.setBackground(Companion.getEMPTY_BACKGROUND());
            $this$createEmptyPanel_u24lambda_u240.setOpaque(true);
            Intrinsics.checkNotNull((Object)$this$createEmptyPanel_u24lambda_u240);
            this.tabbedPane.addDropTarget($this$createEmptyPanel_u24lambda_u240, (Function0<Unit>)((Function0)() -> TabbedPaneWrapper.createEmptyPanel$lambda$0$0(this)));
            return box;
        }

        public final void transferTabsFrom(@NotNull TabbedPaneWrapper other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.tabbedPane.transferTabsFrom(other.tabbedPane);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            return Companion.getPREFERRED_SIZE();
        }

        public final void focus() {
            this.tabbedPane.focus();
        }

        public final void saveWorkspace(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            BuilderKt.addElement$default((Element)element, (String)FrameContent.NODE_NAME_GROUP, null, arg_0 -> TabbedPaneWrapper.saveWorkspace$lambda$0(this, arg_0), (int)2, null);
        }

        public final void readWorkspace(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            for (Element tabElement : DomKt.childElements((Element)element, (String)"tab")) {
                BrowserTab browserTab;
                BrowserTab $this$readWorkspace_u24lambda_u240 = browserTab = BrowserTab.Companion.create(tabElement, FrameContent.this.getFrame());
                boolean bl = false;
                this.tabbedPane.addTab($this$readWorkspace_u24lambda_u240);
                $this$readWorkspace_u24lambda_u240.setBrowserPath(BrowserPath.Companion.create(tabElement));
            }
        }

        private static final void tabbedPane$lambda$0$0(TabbedPaneWrapper this$0, BrowserTabbedPane $this_apply, FrameContent this$1, ChangeEvent it) {
            this$0.showCard($this_apply.getTabCount() == 0 ? FrameContent.CARD_EMPTY : FrameContent.CARD_TABBED_PANE);
            Iterable $this$forEach$iv = this$1.getWrappers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TabbedPaneWrapper it2 = (TabbedPaneWrapper)element$iv;
                boolean bl = false;
                it2.updateMessageLabel();
            }
            this$1.getFrame().getReloadAction().setEnabled(this$1.getTotalTabCount() > 0);
        }

        private static final Unit createEmptyPanel$lambda$0$0(TabbedPaneWrapper this$0) {
            this$0.showCard(FrameContent.CARD_TABBED_PANE);
            return Unit.INSTANCE;
        }

        private static final Unit saveWorkspace$lambda$0(TabbedPaneWrapper this$0, Element $this$addElement) {
            Intrinsics.checkNotNullParameter((Object)$this$addElement, (String)"$this$addElement");
            $this$addElement.setAttribute(FrameContent.ATTRIBUTE_POSITION, this$0.position.name());
            for (BrowserTab tab : this$0.tabbedPane.tabs()) {
                tab.saveWorkspace($this$addElement);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SplitMode.values().length];
            try {
                nArray[SplitMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SplitMode.HORIZONTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SplitMode.VERTICAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SplitMode.BOTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

