/*
 * Copyright 2025 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.probe.embedded;

/**
 * Interface to further customize event enums registered with {@link PayloadProbe#getCustomTypes()}.
 * Your enum class can implement this interface to customize the color of your types.
 */
public interface TypeCustomizer {
    /**
     * The color of your enum constant.
     * @return the RGB int value of a color, for example {@code 0xCCAA00}
     */
    int getColor();
}
