package com.jprofiler.api.agent.heap;

import org.jetbrains.annotations.Nullable;

/**
 * Represents a {@code java.lang.String} instance in a heap dump.
 * Provides a method to retrieve the string value of this instance.
 */
public interface StringInstance extends Instance {
    /**
     * Retrieves the value of this {@code StringInstance}.
     * The value corresponds to the represented {@code java.lang.String} content,
     * or {@code null} if the string value is unavailable because the heap dump doesn't contain primitive data.
     *
     * @return the string value of this instance, or {@code null} if unavailable.
     */
    @Nullable
    String value();
}
