package com.jprofiler.api.agent.heap;

import org.jetbrains.annotations.Nullable;

/**
 * Represents an object instance from a heap dump. Instances provide access
 * to the values of their fields.
 */
public interface Instance extends HeapObject {
    /**
     * Retrieves the value of an instance field for this object based on its index in {@link ClassDescriptor#allInstanceFields()}.
     * The field can hold either a primitive value, a {@link HeapObject}, or one of its subinterfaces.
     *
     * @param fieldIndex the zero-based index of the instance field. The index must be
     *                   within the bounds of the fields defined for the object.
     * @return the value of the instance field at the specified index, or {@code null}
     *         if no field exists with the specified index, if the field is unavailable,
     *         or if the field value itself is {@code null}.
     */
    @Nullable
    Object fieldValue(int fieldIndex);

    /**
     * Retrieves the value of an instance field for this object based on its name.
     * The field can hold either a primitive value, a {@link HeapObject}, or one of its subinterfaces.
     *
     * @param fieldName the name of the instance field to be retrieved. Must not be null.
     * @return the value of the instance field with the specified name, or {@code null}
     *         if no field exists with the specified name, if the field is unavailable,
     *         or if the field value itself is {@code null}.
     */
    @Nullable
    Object fieldValue(String fieldName);
}
