/*
 * Copyright 2025 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.probe.injected.parameter;

import com.jprofiler.api.probe.injected.interception.*;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Assigns the instance that the instrumented method was invoked on to a parameter of a probe method. The probe method can be annotated with {@link Interception}, {@link PayloadInterception},
 * {@link SplitInterception} or {@link AdditionalInterception}. The type of the annotated parameter must be {@code Object} or the type given in {@link MethodSpec#className()}.
 * The declared type can only be used if it can be resolved by the system class loader.
 * <p>If the instrumented method is a static method, the argument will be {@code null}. If the instrumented method is a constructor, the value will be {@code null} for {@link InvocationType#ENTER} because
 * the super constructor has not been invoked yet.</p>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface ThisValue {
}
